/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.registry.autoconfigure;

import io.microsphere.spring.cloud.client.service.registry.DefaultRegistration;
import io.microsphere.spring.cloud.client.service.registry.InMemoryServiceRegistry;
import io.microsphere.spring.cloud.client.service.registry.SimpleAutoServiceRegistration;
import io.microsphere.spring.cloud.client.service.registry.condition.ConditionalOnAutoServiceRegistrationEnabled;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationAutoConfiguration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationConfiguration;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.UtilAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="microsphere.spring.cloud.simple.", name={"enabled"})
@ConditionalOnAutoServiceRegistrationEnabled
@AutoConfigureBefore(value={AutoServiceRegistrationAutoConfiguration.class})
@AutoConfigureAfter(value={UtilAutoConfiguration.class, AutoServiceRegistrationConfiguration.class})
@Import(value={SimpleAutoServiceRegistration.class})
public class SimpleAutoServiceRegistrationAutoConfiguration {
    public static final String PROPERTY_NAME_PREFIX = "microsphere.spring.cloud.simple.";

    @Bean
    public Registration registration(@Value(value="${spring.application.name:default}") String applicationName, ServerProperties serverProperties, InetUtils inetUtils) {
        InetUtils.HostInfo hostInfo = inetUtils.findFirstNonLoopbackHostInfo();
        String host = hostInfo.getIpAddress();
        int port = serverProperties.getPort();
        String instanceId = host + ":" + port;
        DefaultRegistration registration = new DefaultRegistration();
        registration.setInstanceId(instanceId);
        registration.setServiceId(applicationName);
        registration.setHost(host);
        registration.setPort(serverProperties.getPort());
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceRegistry<Registration> serviceRegistry() {
        return new InMemoryServiceRegistry();
    }
}

