/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.registry.autoconfigure;

import io.microsphere.spring.cloud.client.service.registry.autoconfigure.ServiceRegistryAutoConfiguration;
import io.microsphere.spring.cloud.client.service.registry.condition.ConditionalOnAutoServiceRegistrationEnabled;
import io.microsphere.spring.cloud.client.service.util.ServiceInstanceUtils;
import io.microsphere.spring.web.event.WebEndpointMappingsReadyEvent;
import io.microsphere.spring.web.metadata.WebEndpointMapping;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletRegistrationBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"io.microsphere.spring.web.metadata.WebEndpointMapping", "io.microsphere.spring.web.event.WebEndpointMappingsReadyEvent"})
@ConditionalOnBean(value={Registration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnAutoServiceRegistrationEnabled
@AutoConfigureAfter(value={ServiceRegistryAutoConfiguration.class})
public class WebMvcServiceRegistryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(WebMvcServiceRegistryAutoConfiguration.class);
    private static final String[] DEFAULT_URL_MAPPINGS = new String[]{"/*"};
    @Autowired
    private Registration registration;
    @Value(value="${management.endpoints.web.base-path:/actuator}")
    private String actuatorBasePath;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    @Autowired
    private ObjectProvider<FilterRegistrationBean> filterRegistrationBeansProvider;
    @Autowired
    private ObjectProvider<DispatcherServletRegistrationBean> dispatcherServletRegistrationBeanProvider;

    @EventListener(value={WebEndpointMappingsReadyEvent.class})
    public void onApplicationEvent(WebEndpointMappingsReadyEvent event) {
        Collection webEndpointMappings = event.getMappings();
        this.attachWebMappingsMetadata(this.registration, webEndpointMappings);
    }

    private void attachWebMappingsMetadata(Registration registration, Collection<WebEndpointMapping> webEndpointMappings) {
        HashSet<WebEndpointMapping> mappings = new HashSet<WebEndpointMapping>(webEndpointMappings);
        this.excludeMappings(mappings);
        ServiceInstanceUtils.attachMetadata(this.contextPath, (ServiceInstance)registration, mappings);
    }

    private void excludeMappings(Set<WebEndpointMapping> mappings) {
        Iterator<WebEndpointMapping> iterator = mappings.iterator();
        while (iterator.hasNext()) {
            WebEndpointMapping mapping = iterator.next();
            String[] patterns = mapping.getPatterns();
            if (!this.isBuiltInFilterMapping(patterns) && !this.isDispatcherServletMapping(mapping, patterns) && !this.isActuatorWebEndpointMapping(patterns)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("The '{}' was removed", (Object)mapping);
            }
            iterator.remove();
        }
    }

    private boolean isBuiltInFilterMapping(String[] patterns) {
        boolean found = this.filterRegistrationBeansProvider.stream().filter(filterRegistrationBean -> this.matchFilter((FilterRegistrationBean)filterRegistrationBean, patterns)).filter(filterRegistrationBean -> {
            Filter filter = filterRegistrationBean.getFilter();
            Class<?> filterClass = filter.getClass();
            String filterClassName = filterClass.getName();
            return filterClassName.startsWith("org.springframework.");
        }).findFirst().isPresent();
        return found;
    }

    private boolean isDispatcherServletMapping(WebEndpointMapping mapping, String[] patterns) {
        String servletName;
        Object source;
        DispatcherServletRegistrationBean registrationBean = (DispatcherServletRegistrationBean)this.dispatcherServletRegistrationBeanProvider.getIfAvailable();
        if (registrationBean != null && Objects.equals(source = mapping.getEndpoint(), servletName = registrationBean.getServletName())) {
            Collection urlMappings = registrationBean.getUrlMappings();
            return this.matchUrlPatterns(urlMappings, patterns);
        }
        return false;
    }

    private boolean isActuatorWebEndpointMapping(String[] patterns) {
        for (String pattern : patterns) {
            if (!pattern.startsWith(this.actuatorBasePath)) continue;
            return true;
        }
        return false;
    }

    private boolean matchFilter(FilterRegistrationBean filterRegistrationBean, String[] patterns) {
        Collection urlPatterns = filterRegistrationBean.getUrlPatterns();
        return this.matchUrlPatterns(urlPatterns, patterns);
    }

    private boolean matchUrlPatterns(Collection<String> urlPatterns, String[] patterns) {
        Object[] urlPatternsArray = urlPatterns.isEmpty() ? DEFAULT_URL_MAPPINGS : urlPatterns.toArray(new String[0]);
        return Arrays.equals(urlPatternsArray, patterns);
    }
}

