/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.registry.endpoint;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.boot.web.server.WebServer;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationListener;

public class AbstractServiceRegistrationEndpoint
implements SmartInitializingSingleton,
ApplicationListener<WebServerInitializedEvent> {
    @Value(value="${spring.application.name}")
    protected String applicationName;
    @Autowired
    private ObjectProvider<Registration> registrationProvider;
    @Autowired
    private ObjectProvider<ServiceRegistry> serviceRegistryProvider;
    @Autowired
    private ObjectProvider<AbstractAutoServiceRegistration> autoServiceRegistrationProvider;
    protected Registration registration;
    protected ServiceRegistry serviceRegistry;
    protected AbstractAutoServiceRegistration serviceRegistration;
    protected int port;
    protected static boolean running;

    public void afterSingletonsInstantiated() {
        this.registration = (Registration)this.registrationProvider.getIfAvailable();
        this.serviceRegistry = (ServiceRegistry)this.serviceRegistryProvider.getIfAvailable();
        this.serviceRegistration = (AbstractAutoServiceRegistration)this.autoServiceRegistrationProvider.getIfAvailable();
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        WebServer webServer = event.getWebServer();
        this.port = webServer.getPort();
        running = this.serviceRegistration == null ? true : this.serviceRegistration.isRunning();
    }

    protected boolean isRunning() {
        return running;
    }

    public void setRunning(boolean running) {
        AbstractServiceRegistrationEndpoint.running = running;
    }
}

