/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.registry.endpoint;

import io.microsphere.spring.cloud.client.service.registry.endpoint.AbstractServiceRegistrationEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;

@Endpoint(id="serviceDeregistration")
public class ServiceDeregistrationEndpoint
extends AbstractServiceRegistrationEndpoint {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @WriteOperation
    public boolean stop() {
        boolean isRunning = this.isRunning();
        if (isRunning) {
            this.serviceRegistry.deregister(this.registration);
            this.logger.info("Service[name : '{}'] is deregistered!", (Object)this.applicationName);
            this.setRunning(false);
        } else {
            this.logger.warn("Service[name : '{}'] is not registered, deregistration can't be executed!", (Object)this.applicationName);
        }
        return isRunning;
    }
}

