/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.registry.endpoint;

import io.microsphere.spring.cloud.client.service.registry.endpoint.AbstractServiceRegistrationEndpoint;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.util.ReflectionUtils;

@Endpoint(id="serviceRegistration")
public class ServiceRegistrationEndpoint
extends AbstractServiceRegistrationEndpoint {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @ReadOperation
    public Map<String, Object> metadata() {
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        metadata.put("application-name", this.applicationName);
        metadata.put("registration", this.registration);
        metadata.put("port", this.port);
        metadata.put("status", this.serviceRegistry.getStatus(this.registration));
        metadata.put("running", this.isRunning());
        if (this.serviceRegistration != null) {
            metadata.put("enabled", this.invoke("isEnabled"));
            metadata.put("phase", this.serviceRegistration.getPhase());
            metadata.put("order", this.serviceRegistration.getOrder());
            if (Boolean.TRUE.equals(this.invoke("shouldRegisterManagement"))) {
                metadata.put("managementRegistration", this.invoke("getManagementRegistration"));
            }
            metadata.put("config", this.invoke("getConfiguration"));
        }
        return metadata;
    }

    @WriteOperation
    public boolean start() {
        boolean isRunning = this.isRunning();
        if (!isRunning) {
            this.serviceRegistry.register(this.registration);
            this.setRunning(true);
            this.logger.debug("Service[name : '{}'] is registered!", (Object)this.applicationName);
        } else {
            this.logger.warn("Service[name : '{}'] was registered!", (Object)this.applicationName);
        }
        return isRunning;
    }

    private Object invoke(String methodName) {
        Object returnValue = null;
        try {
            Class<AbstractAutoServiceRegistration> serviceRegistrationClass = AbstractAutoServiceRegistration.class;
            Method method = serviceRegistrationClass.getDeclaredMethod(methodName, new Class[0]);
            ReflectionUtils.makeAccessible((Method)method);
            returnValue = method.invoke((Object)this.serviceRegistration, new Object[0]);
        }
        catch (Throwable e) {
            this.logger.error("Invocation on method \uff1a" + methodName + "is failed", e);
        }
        return returnValue;
    }
}

