/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.registry.event;

import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class RegistrationEvent
extends ApplicationEvent {
    private final ServiceRegistry<Registration> registry;

    public RegistrationEvent(ServiceRegistry<Registration> registry, Registration source) {
        super((Object)source);
        Assert.notNull(registry, (String)"The 'registry' must not be null");
        this.registry = registry;
    }

    public Registration getSource() {
        return (Registration)super.getSource();
    }

    @NonNull
    public Registration getRegistration() {
        return this.getSource();
    }

    @NonNull
    public ServiceRegistry<Registration> getRegistry() {
        return this.registry;
    }

    public final boolean isPreRegistered() {
        return !this.isRegistered();
    }

    public abstract boolean isRegistered();

    public final boolean isPreDeregistered() {
        return !this.isDeregistered();
    }

    public abstract boolean isDeregistered();
}

