/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.client.service.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.microsphere.net.URLUtils;
import io.microsphere.spring.web.metadata.WebEndpointMapping;
import io.microsphere.util.BaseUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;

public class ServiceInstanceUtils
extends BaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstanceUtils.class);

    public static void attachMetadata(String contextPath, ServiceInstance serviceInstance, Collection<WebEndpointMapping> webEndpointMappings) {
        Map metadata = serviceInstance.getMetadata();
        StringJoiner jsonBuilder = new StringJoiner(",", "[", "]");
        webEndpointMappings.stream().map(WebEndpointMapping::toJSON).forEach(jsonBuilder::add);
        String json = jsonBuilder.toString();
        metadata.put("web.context-path", contextPath);
        try {
            String encodedJson = URLUtils.encode((String)json);
            metadata.put("web.mappings", encodedJson);
        }
        catch (IllegalArgumentException e) {
            logger.error("The JSON content of WebEndpointMappings can't be encoded : {}", (Object)json, (Object)e);
        }
    }

    public static Collection<WebEndpointMapping> getWebEndpointMappings(ServiceInstance serviceInstance) {
        List webEndpointMappings = Collections.emptyList();
        Map metadata = serviceInstance.getMetadata();
        String encodedJSON = (String)metadata.get("web.mappings");
        if (encodedJSON != null) {
            try {
                String json = URLUtils.decode((String)encodedJSON);
                ObjectMapper objectMapper = new ObjectMapper();
                webEndpointMappings = (List)objectMapper.readValue(json, (TypeReference)new TypeReference<List<WebEndpointMapping>>(){});
            }
            catch (Throwable e) {
                logger.error("The encoded JSON content of WebEndpointMappings can't be parsed : {}", (Object)encodedJSON, (Object)e);
            }
        }
        return webEndpointMappings;
    }
}

