/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.fault.tolerance.tomcat.autoconfigure;

import io.microsphere.spring.cloud.fault.tolerance.tomcat.event.TomcatDynamicConfigurationListener;
import org.apache.catalina.startup.Tomcat;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.embedded.EmbeddedWebServerFactoryCustomizerAutoConfiguration;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.server.WebServer;
import org.springframework.cloud.autoconfigure.ConfigurationPropertiesRebinderAutoConfiguration;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.EventListener;

@ConditionalOnProperty(prefix="microsphere.spring.cloud.fault-tolerance.tomcat", name={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={EnvironmentChangeEvent.class, Tomcat.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@AutoConfigureAfter(value={EmbeddedWebServerFactoryCustomizerAutoConfiguration.class, ConfigurationPropertiesRebinderAutoConfiguration.class})
public class TomcatFaultToleranceAutoConfiguration {
    public static final String TOMCAT_PROPERTY_PREFIX = "microsphere.spring.cloud.fault-tolerance.tomcat";

    @EventListener(value={WebServerInitializedEvent.class})
    public void onWebServerInitializedEvent(WebServerInitializedEvent event) {
        WebServerApplicationContext webServerApplicationContext = event.getApplicationContext();
        if (webServerApplicationContext instanceof ConfigurableWebServerApplicationContext) {
            ConfigurableWebServerApplicationContext context = (ConfigurableWebServerApplicationContext)webServerApplicationContext;
            ObjectProvider beanProvider = context.getBeanProvider(ServerProperties.class);
            beanProvider.ifAvailable(serverProperties -> {
                WebServer webServer = event.getWebServer();
                if (webServer instanceof TomcatWebServer) {
                    TomcatWebServer tomcatWebServer = (TomcatWebServer)webServer;
                    context.addApplicationListener((ApplicationListener)new TomcatDynamicConfigurationListener(tomcatWebServer, (ServerProperties)serverProperties, (ConfigurableApplicationContext)context));
                }
            });
        }
    }
}

