/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cloud.fault.tolerance.tomcat.event;

import io.microsphere.spring.boot.context.properties.bind.util.BindUtils;
import io.microsphere.spring.util.EnvironmentUtils;
import io.microsphere.spring.util.PropertySourcesUtils;
import io.microsphere.util.Configurer;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.unit.DataSize;

public class TomcatDynamicConfigurationListener
implements ApplicationListener<EnvironmentChangeEvent> {
    private static final Logger logger = LoggerFactory.getLogger(TomcatDynamicConfigurationListener.class);
    private static final String SERVER_PROPERTIES_PREFIX = "server";
    private final TomcatWebServer tomcatWebServer;
    private final ServerProperties serverProperties;
    private final ConfigurableApplicationContext context;
    private final ConfigurableEnvironment environment;
    private final boolean configurationPropertiesRebinderPresent;
    private volatile ServerProperties currentServerProperties;

    public TomcatDynamicConfigurationListener(TomcatWebServer tomcatWebServer, ServerProperties serverProperties, ConfigurableApplicationContext context) {
        this.tomcatWebServer = tomcatWebServer;
        this.serverProperties = serverProperties;
        ConfigurableEnvironment environment = context.getEnvironment();
        this.context = context;
        this.environment = environment;
        this.configurationPropertiesRebinderPresent = this.isBeanPresent(ConfigurationPropertiesRebinder.class);
        this.initCurrentServerProperties();
    }

    private void initCurrentServerProperties() {
        this.currentServerProperties = this.getCurrentServerProperties(this.environment);
    }

    private boolean isBeanPresent(Class<?> beanType) {
        return this.context.getBeanProvider(ConfigurationPropertiesRebinder.class).getIfAvailable() != null;
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        if (!this.isSourceFrom(event)) {
            logger.debug("Current context[id : '{}'] receives the other changed property names : {}", (Object)this.context.getId(), (Object)event.getKeys());
            return;
        }
        Set<String> serverPropertyNames = this.filterServerPropertyNames(event);
        if (serverPropertyNames.isEmpty()) {
            logger.debug("Current context[id : '{}'] does not receive the property change of ServerProperties, keys : {}", (Object)this.context.getId(), (Object)event.getKeys());
            return;
        }
        this.configureTomcatIfChanged(serverPropertyNames);
    }

    private ServerProperties getCurrentServerProperties(ConfigurableEnvironment environment) {
        Map properties = PropertySourcesUtils.getSubProperties((ConfigurableEnvironment)environment, (String)SERVER_PROPERTIES_PREFIX);
        return (ServerProperties)BindUtils.bind((Map)properties, (String)"", ServerProperties.class);
    }

    private boolean isSourceFrom(EnvironmentChangeEvent event) {
        return this.context.equals(event.getSource());
    }

    private Set<String> filterServerPropertyNames(EnvironmentChangeEvent event) {
        return event.getKeys().stream().filter(this::isServerPropertyName).collect(Collectors.toSet());
    }

    private boolean isServerPropertyName(String propertyName) {
        return propertyName.startsWith(SERVER_PROPERTIES_PREFIX);
    }

    private void configureTomcatIfChanged(Set<String> serverPropertyNames) {
        ServerProperties refreshableServerProperties = this.getRefreshableServerProperties(serverPropertyNames);
        logger.debug("The ServerProperties property is changed to: {}", (Object)EnvironmentUtils.getProperties((Environment)this.environment, serverPropertyNames));
        this.configureConnector(refreshableServerProperties);
        this.initCurrentServerProperties();
    }

    private ServerProperties getRefreshableServerProperties(Set<String> serverPropertyNames) {
        if (this.configurationPropertiesRebinderPresent) {
            return this.serverProperties;
        }
        return this.bindServerProperties(serverPropertyNames);
    }

    private ServerProperties bindServerProperties(Set<String> serverPropertyNames) {
        Map serverProperties = EnvironmentUtils.getProperties((Environment)this.environment, serverPropertyNames);
        return (ServerProperties)BindUtils.bind((Map)serverProperties, (String)SERVER_PROPERTIES_PREFIX, ServerProperties.class);
    }

    private void configureConnector(ServerProperties refreshableServerProperties) {
        Connector connector = this.tomcatWebServer.getTomcat().getConnector();
        ProtocolHandler protocolHandler = connector.getProtocolHandler();
        this.configureProtocol(refreshableServerProperties, protocolHandler);
        this.configureHttp11Protocol(refreshableServerProperties, connector, protocolHandler);
    }

    private void configureProtocol(ServerProperties refreshableServerProperties, ProtocolHandler protocolHandler) {
        if (protocolHandler instanceof AbstractProtocol) {
            ServerProperties.Tomcat refreshableTomcatProperties = refreshableServerProperties.getTomcat();
            ServerProperties currentServerProperties = this.currentServerProperties;
            ServerProperties.Tomcat currentTomcatProperties = currentServerProperties.getTomcat();
            AbstractProtocol protocol = (AbstractProtocol)protocolHandler;
            Configurer.configure((String)"Tomcat thread pool's core size").value(() -> ((ServerProperties.Tomcat.Threads)refreshableTomcatProperties.getThreads()).getMinSpare()).on(this::isPositive).compare(() -> ((ServerProperties.Tomcat.Threads)currentTomcatProperties.getThreads()).getMinSpare()).apply(arg_0 -> ((AbstractProtocol)protocol).setMinSpareThreads(arg_0));
            Configurer.configure((String)"Tomcat thread pool's max size").value(() -> ((ServerProperties.Tomcat.Threads)refreshableTomcatProperties.getThreads()).getMax()).on(this::isPositive).compare(() -> ((ServerProperties.Tomcat.Threads)currentTomcatProperties.getThreads()).getMax()).apply(arg_0 -> ((AbstractProtocol)protocol).setMaxThreads(arg_0));
            Configurer.configure((String)"Tomcat Endpoint Network backlog").value(() -> ((ServerProperties.Tomcat)refreshableTomcatProperties).getAcceptCount()).on(this::isPositive).compare(() -> ((ServerProperties.Tomcat)currentTomcatProperties).getAcceptCount()).apply(arg_0 -> ((AbstractProtocol)protocol).setAcceptCount(arg_0));
            Configurer.configure((String)"Tomcat connection timeout(ms)").value(() -> ((ServerProperties.Tomcat)refreshableTomcatProperties).getConnectionTimeout()).compare(() -> ((ServerProperties.Tomcat)currentTomcatProperties).getConnectionTimeout()).as(this::toIntMillis).on(this::isPositive).apply(arg_0 -> ((AbstractProtocol)protocol).setConnectionTimeout(arg_0));
            Configurer.configure((String)"Tomcat max connections").value(() -> ((ServerProperties.Tomcat)refreshableTomcatProperties).getMaxConnections()).on(this::isPositive).compare(() -> ((ServerProperties.Tomcat)currentTomcatProperties).getMaxConnections()).apply(arg_0 -> ((AbstractProtocol)protocol).setMaxConnections(arg_0));
        }
    }

    private void configureHttp11Protocol(ServerProperties refreshableServerProperties, Connector connector, ProtocolHandler protocolHandler) {
        if (protocolHandler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)protocolHandler;
            ServerProperties.Tomcat refreshableTomcatProperties = refreshableServerProperties.getTomcat();
            ServerProperties currentServerProperties = this.currentServerProperties;
            ServerProperties.Tomcat currentTomcatProperties = currentServerProperties.getTomcat();
            Configurer.configure((String)"Tomcat HTTP Headers' max size(bytes)").value(() -> ((ServerProperties)refreshableServerProperties).getMaxHttpHeaderSize()).compare(() -> ((ServerProperties)currentServerProperties).getMaxHttpHeaderSize()).as(this::toIntBytes).on(this::isPositive).apply(arg_0 -> ((AbstractHttp11Protocol)protocol).setMaxHttpHeaderSize(arg_0));
            Configurer.configure((String)"Tomcat HTTP Body's max size(bytes)").value(() -> ((ServerProperties.Tomcat)refreshableTomcatProperties).getMaxSwallowSize()).compare(() -> ((ServerProperties.Tomcat)currentTomcatProperties).getMaxSwallowSize()).as(this::toIntBytes).on(this::isPositive).apply(arg_0 -> ((AbstractHttp11Protocol)protocol).setMaxSwallowSize(arg_0));
            Configurer.configure((String)"Tomcat HTTP max POST size(bytes)").value(() -> ((ServerProperties.Tomcat)refreshableTomcatProperties).getMaxHttpFormPostSize()).compare(() -> ((ServerProperties.Tomcat)currentTomcatProperties).getMaxHttpFormPostSize()).as(this::toIntBytes).on(this::isPositive).apply(arg_0 -> ((Connector)connector).setMaxPostSize(arg_0));
        }
    }

    private int toIntMillis(Duration duration) {
        return (int)duration.toMillis();
    }

    private int toIntBytes(DataSize dataSize) {
        return (int)dataSize.toBytes();
    }

    private boolean isPositive(int value) {
        return value > 0;
    }
}

