/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory;

import io.microsphere.spring.beans.factory.InjectionPointDependencyResolver;
import io.microsphere.spring.util.SpringFactoriesLoaderUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class InjectionPointDependencyResolvers
implements InjectionPointDependencyResolver {
    private final Iterable<InjectionPointDependencyResolver> resolvers;

    public InjectionPointDependencyResolvers(BeanFactory beanFactory) {
        this(SpringFactoriesLoaderUtils.loadFactories(beanFactory, InjectionPointDependencyResolver.class));
    }

    public InjectionPointDependencyResolvers(Iterable<InjectionPointDependencyResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public void resolve(Field field, ConfigurableListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        this.resolvers.forEach(resolver -> resolver.resolve(field, beanFactory, dependentBeanNames));
    }

    @Override
    public void resolve(Method method, ConfigurableListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        this.resolvers.forEach(resolver -> resolver.resolve(method, beanFactory, dependentBeanNames));
    }

    @Override
    public void resolve(Constructor constructor, ConfigurableListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        this.resolvers.forEach(resolver -> resolver.resolve(constructor, beanFactory, dependentBeanNames));
    }

    @Override
    public void resolve(Parameter parameter, ConfigurableListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        this.resolvers.forEach(resolver -> resolver.resolve(parameter, beanFactory, dependentBeanNames));
    }
}

