/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory.annotation;

import io.microsphere.spring.util.AnnotationUtils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AnnotatedInjectionBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements MergedBeanDefinitionPostProcessor,
PriorityOrdered,
BeanFactoryAware,
BeanClassLoaderAware,
EnvironmentAware,
InitializingBean,
DisposableBean {
    private static final int CACHE_SIZE = Integer.getInteger("microsphere.spring.injection.metadata.cache.size", 32);
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Collection<Class<? extends Annotation>> annotationTypes;
    private ConcurrentMap<Class<?>, Constructor<?>[]> candidateConstructorsCache;
    private ConcurrentMap<String, AnnotatedInjectionMetadata> injectionMetadataCache;
    private ConfigurableListableBeanFactory beanFactory;
    private Environment environment;
    private ClassLoader classLoader;
    private int order = 0x7FFFFFFC;
    private boolean classValuesAsString;
    private boolean nestedAnnotationsAsMap;
    private boolean ignoreDefaultValue = true;
    private boolean tryMergedAnnotation = true;
    private int cacheSize = CACHE_SIZE;

    public AnnotatedInjectionBeanPostProcessor(Class<? extends Annotation> annotationType, Class<? extends Annotation> ... otherAnnotationTypes) {
        this(AnnotatedInjectionBeanPostProcessor.combine(Collections.singleton(annotationType), Arrays.asList(otherAnnotationTypes)));
    }

    public AnnotatedInjectionBeanPostProcessor(Collection<Class<? extends Annotation>> annotationTypes) {
        Assert.notEmpty(annotationTypes, (String)"The argument of annotations' types must not empty");
        this.annotationTypes = annotationTypes;
    }

    private static <T> Collection<T> combine(Collection<? extends T> ... elements) {
        ArrayList<? extends T> allElements = new ArrayList<T>();
        for (Collection<? extends T> e : elements) {
            allElements.addAll(e);
        }
        return allElements;
    }

    public final Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return Collections.unmodifiableCollection(this.annotationTypes);
    }

    public final void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"AnnotationInjectedBeanPostProcessor requires a ConfigurableListableBeanFactory");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Constructor<?>[] determineCandidateConstructors(Class<?> beanClass, String beanName) throws BeansException {
        Constructor[] candidateConstructors = (Constructor[])this.candidateConstructorsCache.get(beanClass);
        if (candidateConstructors == null) {
            ConcurrentMap<Class<?>, Constructor<?>[]> concurrentMap = this.candidateConstructorsCache;
            synchronized (concurrentMap) {
                candidateConstructors = (Constructor[])this.candidateConstructorsCache.get(beanClass);
                if (candidateConstructors == null) {
                    Constructor<?>[] rawCandidates;
                    try {
                        rawCandidates = beanClass.getDeclaredConstructors();
                    }
                    catch (Throwable ex) {
                        throw new BeanCreationException(beanName, "Resolution of declared constructors on bean Class [" + beanClass.getName() + "] from ClassLoader [" + beanClass.getClassLoader() + "] failed", ex);
                    }
                    ArrayList candidates = new ArrayList(rawCandidates.length);
                    Constructor<?> requiredConstructor = null;
                    Constructor<?> defaultConstructor = null;
                    Constructor primaryConstructor = BeanUtils.findPrimaryConstructor(beanClass);
                    int nonSyntheticConstructors = 0;
                    for (Constructor<?> candidate : rawCandidates) {
                        Class userClass;
                        if (!candidate.isSynthetic()) {
                            ++nonSyntheticConstructors;
                        } else if (primaryConstructor != null) continue;
                        AnnotationAttributes ann = this.findInjectionAnnotationAttributes(candidate);
                        if (ann == null && (userClass = ClassUtils.getUserClass(beanClass)) != beanClass) {
                            try {
                                Constructor superCtor = userClass.getDeclaredConstructor(candidate.getParameterTypes());
                                ann = this.findInjectionAnnotationAttributes(superCtor);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                        if (ann != null) {
                            if (requiredConstructor != null) {
                                throw new BeanCreationException(beanName, "Invalid injection constructor: " + candidate + ". Found constructor with 'required' Autowired annotation already: " + requiredConstructor);
                            }
                            boolean required = this.determineRequiredStatus(ann);
                            if (required) {
                                if (!candidates.isEmpty()) {
                                    throw new BeanCreationException(beanName, "Invalid injection constructors: " + candidates + ". Found constructor with 'required' Autowired annotation: " + candidate);
                                }
                                requiredConstructor = candidate;
                            }
                            candidates.add(candidate);
                            continue;
                        }
                        if (candidate.getParameterCount() != 0) continue;
                        defaultConstructor = candidate;
                    }
                    if (!candidates.isEmpty()) {
                        if (requiredConstructor == null) {
                            if (defaultConstructor != null) {
                                candidates.add(defaultConstructor);
                            } else if (candidates.size() == 1 && this.logger.isInfoEnabled()) {
                                this.logger.info((Object)("Inconsistent constructor declaration on bean with name '" + beanName + "': single injection constructor flagged as optional - this constructor is effectively required since there is no default constructor to fall back to: " + candidates.get(0)));
                            }
                        }
                        candidateConstructors = candidates.toArray(new Constructor[0]);
                    } else {
                        candidateConstructors = rawCandidates.length == 1 && rawCandidates[0].getParameterCount() > 0 ? new Constructor[]{rawCandidates[0]} : (nonSyntheticConstructors == 2 && primaryConstructor != null && defaultConstructor != null && !primaryConstructor.equals(defaultConstructor) ? new Constructor[]{primaryConstructor, defaultConstructor} : (nonSyntheticConstructors == 1 && primaryConstructor != null ? new Constructor[]{primaryConstructor} : new Constructor[]{}));
                    }
                    this.candidateConstructorsCache.put(beanClass, candidateConstructors);
                }
            }
        }
        return candidateConstructors.length > 0 ? candidateConstructors : null;
    }

    public final PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeanCreationException {
        return this.postProcessProperties(pvs, bean, beanName);
    }

    public final PropertyValues postProcessProperties(PropertyValues pvs, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.findInjectionMetadata(beanName, bean.getClass(), pvs);
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (BeanCreationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of @" + this.getAnnotationTypes() + " dependencies is failed", ex);
        }
        return pvs;
    }

    private List<AnnotatedFieldElement> findFieldAnnotationMetadata(Class<?> beanClass) {
        final LinkedList<AnnotatedFieldElement> elements = new LinkedList<AnnotatedFieldElement>();
        ReflectionUtils.doWithFields(beanClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                for (Class<? extends Annotation> annotationType : AnnotatedInjectionBeanPostProcessor.this.getAnnotationTypes()) {
                    AnnotationAttributes attributes = AnnotatedInjectionBeanPostProcessor.this.doGetAnnotationAttributes(field, annotationType);
                    if (attributes == null) continue;
                    if (Modifier.isStatic(field.getModifiers())) {
                        if (AnnotatedInjectionBeanPostProcessor.this.logger.isWarnEnabled()) {
                            AnnotatedInjectionBeanPostProcessor.this.logger.warn((Object)("@" + annotationType.getName() + " is not supported on static fields: " + field));
                        }
                        return;
                    }
                    boolean required = AnnotatedInjectionBeanPostProcessor.this.determineRequiredStatus(attributes);
                    elements.add(new AnnotatedFieldElement(field, attributes, required));
                }
            }
        });
        return elements;
    }

    protected boolean determineRequiredStatus(AnnotationAttributes attributes) {
        return true;
    }

    private List<AnnotatedMethodElement> findAnnotatedMethodMetadata(final Class<?> beanClass) {
        final LinkedList<AnnotatedMethodElement> elements = new LinkedList<AnnotatedMethodElement>();
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)method, (Method)bridgedMethod)) {
                    return;
                }
                for (Class<? extends Annotation> annotationType : AnnotatedInjectionBeanPostProcessor.this.getAnnotationTypes()) {
                    AnnotationAttributes attributes = AnnotatedInjectionBeanPostProcessor.this.doGetAnnotationAttributes(bridgedMethod, annotationType);
                    if (attributes == null || !method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)beanClass))) continue;
                    if (Modifier.isStatic(method.getModifiers())) {
                        if (AnnotatedInjectionBeanPostProcessor.this.logger.isWarnEnabled()) {
                            AnnotatedInjectionBeanPostProcessor.this.logger.warn((Object)("@" + annotationType.getName() + " annotation is not supported on static methods: " + method));
                        }
                        return;
                    }
                    if (method.getParameterTypes().length == 0 && AnnotatedInjectionBeanPostProcessor.this.logger.isWarnEnabled()) {
                        AnnotatedInjectionBeanPostProcessor.this.logger.warn((Object)("@" + annotationType.getName() + " annotation should only be used on methods with parameters: " + method));
                    }
                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, (Class)beanClass);
                    boolean required = AnnotatedInjectionBeanPostProcessor.this.determineRequiredStatus(attributes);
                    elements.add(new AnnotatedMethodElement(method, pd, attributes, required));
                }
            }
        });
        return elements;
    }

    protected final AnnotationAttributes findInjectionAnnotationAttributes(AnnotatedElement annotatedElement) {
        Class<? extends Annotation> annotationType;
        AnnotationAttributes annotationAttributes = null;
        Iterator<Class<? extends Annotation>> iterator = this.getAnnotationTypes().iterator();
        while (iterator.hasNext() && (annotationAttributes = this.doGetAnnotationAttributes(annotatedElement, annotationType = iterator.next())) == null) {
        }
        return annotationAttributes;
    }

    protected final AnnotationAttributes doGetAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getAnnotationAttributes(annotatedElement, annotationType, (PropertyResolver)this.getEnvironment(), this.classValuesAsString, this.nestedAnnotationsAsMap, this.ignoreDefaultValue, this.tryMergedAnnotation, new String[0]);
    }

    private AnnotatedInjectionMetadata buildAnnotatedMetadata(Class<?> beanClass) {
        List<AnnotatedFieldElement> fieldElements = this.findFieldAnnotationMetadata(beanClass);
        List<AnnotatedMethodElement> methodElements = this.findAnnotatedMethodMetadata(beanClass);
        return new AnnotatedInjectionMetadata(beanClass, fieldElements, methodElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findInjectionMetadata(String beanName, Class<?> clazz, PropertyValues pvs) {
        String cacheKey = StringUtils.hasLength((String)beanName) ? beanName : clazz.getName();
        AnnotatedInjectionMetadata metadata = (AnnotatedInjectionMetadata)((Object)this.injectionMetadataCache.get(cacheKey));
        if (InjectionMetadata.needsRefresh((InjectionMetadata)metadata, clazz)) {
            ConcurrentMap<String, AnnotatedInjectionMetadata> concurrentMap = this.injectionMetadataCache;
            synchronized (concurrentMap) {
                metadata = (AnnotatedInjectionMetadata)((Object)this.injectionMetadataCache.get(cacheKey));
                if (InjectionMetadata.needsRefresh((InjectionMetadata)metadata, clazz)) {
                    if (metadata != null) {
                        metadata.clear(pvs);
                    }
                    try {
                        metadata = this.buildAnnotatedMetadata(clazz);
                        this.injectionMetadataCache.put(cacheKey, metadata);
                    }
                    catch (NoClassDefFoundError err) {
                        throw new IllegalStateException("Failed to introspect object class [" + clazz.getName() + "] for annotation metadata: could not find class that it depends on", err);
                    }
                }
            }
        }
        return metadata;
    }

    public final void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        if (beanType != null) {
            InjectionMetadata metadata = this.findInjectionMetadata(beanName, beanType, null);
            metadata.checkConfigMembers(beanDefinition);
        }
    }

    public final void setClassValuesAsString(boolean classValuesAsString) {
        this.classValuesAsString = classValuesAsString;
    }

    public final void setNestedAnnotationsAsMap(boolean nestedAnnotationsAsMap) {
        this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
    }

    public final void setIgnoreDefaultValue(boolean ignoreDefaultValue) {
        this.ignoreDefaultValue = ignoreDefaultValue;
    }

    public final void setTryMergedAnnotation(boolean tryMergedAnnotation) {
        this.tryMergedAnnotation = tryMergedAnnotation;
    }

    public final void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public final void setOrder(int order) {
        this.order = order;
    }

    public final void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public final void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() throws Exception {
        this.candidateConstructorsCache = new ConcurrentHashMap(this.cacheSize);
        this.injectionMetadataCache = new ConcurrentHashMap<String, AnnotatedInjectionMetadata>(this.cacheSize);
    }

    public void destroy() throws Exception {
        this.candidateConstructorsCache.clear();
        this.injectionMetadataCache.clear();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(((Object)((Object)this)).getClass() + " was destroying!"));
        }
    }

    protected Object resolveInjectedFieldValue(Object bean, String beanName, PropertyValues pvs, AnnotationInjectedElement<Field> fieldElement) throws Throwable {
        return null;
    }

    protected Object[] resolveInjectedMethodArguments(Object bean, String beanName, PropertyValues pvs, AnnotationInjectedElement<Method> methodElement) throws Throwable {
        return null;
    }

    protected final Object resolveDependency(DependencyDescriptor desc, String beanName, Set<String> injectedBeanNames) {
        TypeConverter typeConverter = this.beanFactory.getTypeConverter();
        Object value = null;
        try {
            value = this.beanFactory.resolveDependency(desc, beanName, injectedBeanNames, typeConverter);
        }
        catch (BeansException ex) {
            throw new UnsatisfiedDependencyException(null, beanName, (InjectionPoint)desc, ex);
        }
        return value;
    }

    private void registerDependentBeans(String beanName, Set<String> injectedBeanNames) {
        if (beanName != null) {
            for (String injectedBeanName : injectedBeanNames) {
                if (this.beanFactory.containsBean(injectedBeanName)) {
                    this.beanFactory.registerDependentBean(injectedBeanName, beanName);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Injected by type from bean name '" + beanName + "' to bean named '" + injectedBeanName + "'"));
            }
        }
    }

    private Object resolvedCachedArgument(String beanName, Object cachedArgument) {
        if (cachedArgument instanceof DependencyDescriptor) {
            DependencyDescriptor descriptor = (DependencyDescriptor)cachedArgument;
            TypeConverter typeConverter = this.beanFactory.getTypeConverter();
            return this.beanFactory.resolveDependency(descriptor, beanName, null, typeConverter);
        }
        if (cachedArgument instanceof RuntimeBeanReference) {
            return this.beanFactory.getBean(((RuntimeBeanReference)cachedArgument).getBeanName());
        }
        return cachedArgument;
    }

    public final int getOrder() {
        return this.order;
    }

    public final Environment getEnvironment() {
        return this.environment;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    private static class ShortcutDependencyDescriptor
    extends DependencyDescriptor {
        private final String shortcut;
        private final Class<?> requiredType;

        public ShortcutDependencyDescriptor(DependencyDescriptor original, String shortcut, Class<?> requiredType) {
            super(original);
            this.shortcut = shortcut;
            this.requiredType = requiredType;
        }

        public Object resolveShortcut(BeanFactory beanFactory) {
            return beanFactory.getBean(this.shortcut, this.requiredType);
        }
    }

    private class AnnotatedMethodElement
    extends AnnotationInjectedElement<Method> {
        private volatile boolean cached;
        private volatile Object[] cachedMethodArguments;

        protected AnnotatedMethodElement(Method method, PropertyDescriptor pd, AnnotationAttributes attributes, boolean required) {
            super(method, pd, attributes, required);
            this.cached = false;
        }

        protected void inject(Object bean, @Nullable String beanName, @Nullable PropertyValues pvs) throws Throwable {
            Object[] arguments;
            if (this.checkPropertySkipping(pvs)) {
                return;
            }
            Method method = (Method)this.getInjectionPoint();
            if (this.cached) {
                try {
                    arguments = this.resolveCachedArguments(beanName);
                }
                catch (NoSuchBeanDefinitionException ex) {
                    arguments = this.resolveMethodArguments(method, bean, beanName, pvs);
                }
            } else {
                arguments = this.resolveMethodArguments(method, bean, beanName, pvs);
            }
            if (arguments != null) {
                try {
                    ReflectionUtils.makeAccessible((Method)method);
                    method.invoke(bean, arguments);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
        }

        @Nullable
        private Object[] resolveCachedArguments(@Nullable String beanName) {
            Object[] cachedMethodArguments = this.cachedMethodArguments;
            if (cachedMethodArguments == null) {
                return null;
            }
            Object[] arguments = new Object[cachedMethodArguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = AnnotatedInjectionBeanPostProcessor.this.resolvedCachedArgument(beanName, cachedMethodArguments[i]);
            }
            return arguments;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Object[] resolveMethodArguments(Method method, Object bean, @Nullable String beanName, @Nullable PropertyValues pvs) throws Throwable {
            Object[] arguments = AnnotatedInjectionBeanPostProcessor.this.resolveInjectedMethodArguments(bean, beanName, pvs, this);
            if (arguments == null) {
                boolean required = this.isRequired();
                int argumentCount = method.getParameterCount();
                arguments = new Object[argumentCount];
                DependencyDescriptor[] descriptors = new DependencyDescriptor[argumentCount];
                LinkedHashSet<String> injectedBeanNames = new LinkedHashSet<String>(argumentCount);
                for (int i = 0; i < arguments.length; ++i) {
                    MethodParameter methodParam = new MethodParameter(method, i);
                    DependencyDescriptor currDesc = new DependencyDescriptor(methodParam, required);
                    currDesc.setContainingClass(bean.getClass());
                    descriptors[i] = currDesc;
                    Object arg = AnnotatedInjectionBeanPostProcessor.this.resolveDependency(currDesc, beanName, injectedBeanNames);
                    if (arg == null && !required) {
                        arguments = null;
                        break;
                    }
                    arguments[i] = arg;
                }
                AnnotatedMethodElement annotatedMethodElement = this;
                synchronized (annotatedMethodElement) {
                    if (!this.cached) {
                        if (arguments != null) {
                            DependencyDescriptor[] cachedMethodArguments = Arrays.copyOf(descriptors, arguments.length);
                            AnnotatedInjectionBeanPostProcessor.this.registerDependentBeans(beanName, injectedBeanNames);
                            if (injectedBeanNames.size() == argumentCount) {
                                Iterator it = injectedBeanNames.iterator();
                                Class<?>[] paramTypes = method.getParameterTypes();
                                for (int i = 0; i < paramTypes.length; ++i) {
                                    String autowiredBeanName = (String)it.next();
                                    if (!AnnotatedInjectionBeanPostProcessor.this.beanFactory.containsBean(autowiredBeanName) || !AnnotatedInjectionBeanPostProcessor.this.beanFactory.isTypeMatch(autowiredBeanName, paramTypes[i])) continue;
                                    cachedMethodArguments[i] = new ShortcutDependencyDescriptor(descriptors[i], autowiredBeanName, paramTypes[i]);
                                }
                            }
                            this.cachedMethodArguments = cachedMethodArguments;
                        } else {
                            this.cachedMethodArguments = null;
                        }
                        this.cached = true;
                    }
                }
            }
            return arguments;
        }
    }

    private class AnnotatedFieldElement
    extends AnnotationInjectedElement<Field> {
        private volatile boolean cached;
        private volatile Object cachedFieldValue;

        protected AnnotatedFieldElement(Field field, AnnotationAttributes attributes, boolean required) {
            super(field, null, attributes, required);
            this.cached = false;
        }

        protected void inject(Object bean, @Nullable String beanName, @Nullable PropertyValues pvs) throws Throwable {
            Object value;
            Field field = (Field)this.getInjectionPoint();
            if (this.cached) {
                try {
                    value = AnnotatedInjectionBeanPostProcessor.this.resolvedCachedArgument(beanName, this.cachedFieldValue);
                }
                catch (NoSuchBeanDefinitionException ex) {
                    value = this.resolveFieldValue(field, bean, beanName, pvs);
                }
            } else {
                value = this.resolveFieldValue(field, bean, beanName, pvs);
            }
            if (value != null) {
                ReflectionUtils.makeAccessible((Field)field);
                field.set(bean, value);
            }
        }

        @Nullable
        private Object resolveFieldValue(Field field, Object bean, @Nullable String beanName, @Nullable PropertyValues pvs) throws Throwable {
            Object value = AnnotatedInjectionBeanPostProcessor.this.resolveInjectedFieldValue(bean, beanName, pvs, this);
            if (value == null) {
                boolean required = this.isRequired();
                DependencyDescriptor desc = new DependencyDescriptor(field, required);
                desc.setContainingClass(bean.getClass());
                LinkedHashSet<String> injectedBeanNames = new LinkedHashSet<String>(1);
                value = AnnotatedInjectionBeanPostProcessor.this.resolveDependency(desc, beanName, injectedBeanNames);
                this.cacheFieldValue(field, desc, beanName, injectedBeanNames, value, required);
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cacheFieldValue(Field field, DependencyDescriptor desc, String beanName, Set<String> injectedBeanNames, Object value, boolean required) {
            AnnotatedFieldElement annotatedFieldElement = this;
            synchronized (annotatedFieldElement) {
                if (!this.cached) {
                    DependencyDescriptor cachedFieldValue = null;
                    if (value != null || required) {
                        cachedFieldValue = desc;
                        AnnotatedInjectionBeanPostProcessor.this.registerDependentBeans(beanName, injectedBeanNames);
                        if (injectedBeanNames.size() == 1) {
                            String autowiredBeanName = injectedBeanNames.iterator().next();
                            if (AnnotatedInjectionBeanPostProcessor.this.beanFactory.containsBean(autowiredBeanName) && AnnotatedInjectionBeanPostProcessor.this.beanFactory.isTypeMatch(autowiredBeanName, field.getType())) {
                                cachedFieldValue = new ShortcutDependencyDescriptor(desc, autowiredBeanName, field.getType());
                            }
                        }
                    }
                    this.cachedFieldValue = cachedFieldValue;
                    this.cached = true;
                }
            }
        }
    }

    public static abstract class AnnotationInjectedElement<M extends Member>
    extends InjectionMetadata.InjectedElement {
        private final AnnotationAttributes attributes;
        private final boolean required;

        protected AnnotationInjectedElement(M member, PropertyDescriptor pd, AnnotationAttributes attributes, boolean required) {
            super(member, pd);
            this.attributes = attributes;
            this.required = required;
        }

        public final AnnotationAttributes getAttributes() {
            return this.attributes;
        }

        public final boolean isRequired() {
            return this.required;
        }

        public final M getInjectionPoint() {
            return (M)this.getMember();
        }
    }

    private static class AnnotatedInjectionMetadata
    extends InjectionMetadata {
        private final Collection<AnnotatedFieldElement> fieldElements;
        private final Collection<AnnotatedMethodElement> methodElements;

        public AnnotatedInjectionMetadata(Class<?> targetClass, Collection<AnnotatedFieldElement> fieldElements, Collection<AnnotatedMethodElement> methodElements) {
            super(targetClass, AnnotatedInjectionBeanPostProcessor.combine(new Collection[]{fieldElements, methodElements}));
            this.fieldElements = fieldElements;
            this.methodElements = methodElements;
        }

        public Collection<AnnotatedFieldElement> getFieldElements() {
            return this.fieldElements;
        }

        public Collection<AnnotatedMethodElement> getMethodElements() {
            return this.methodElements;
        }
    }
}

