/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory.annotation;

import io.microsphere.spring.beans.factory.annotation.AnnotatedInjectionPointDependencyResolver;
import java.beans.Introspector;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.StringUtils;

public class ResourceInjectionPointDependencyResolver
extends AnnotatedInjectionPointDependencyResolver<Resource> {
    @Override
    public Resource getAnnotation(Parameter parameter) {
        Executable executable = parameter.getDeclaringExecutable();
        Resource resource = (Resource)super.getAnnotation(executable);
        return resource;
    }

    @Override
    public void resolve(Field field, ConfigurableListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        Resource resource = (Resource)this.getAnnotation(field);
        if (resource == null) {
            return;
        }
        Class beanType = resource.type();
        if (Object.class.equals((Object)beanType)) {
            String beanName = this.resolveBeanName(field, resource, beanFactory);
            dependentBeanNames.add(beanName);
        } else {
            String[] beanNames;
            for (String name : beanNames = beanFactory.getBeanNamesForType(beanType, false, false)) {
                dependentBeanNames.add(name);
            }
        }
    }

    private String resolveBeanName(Field field, Resource resource, ConfigurableListableBeanFactory beanFactory) {
        String name = resource.name();
        if (StringUtils.hasText((String)name)) {
            return name;
        }
        return field.getName();
    }

    private String resolveBeanName(Parameter parameter, Resource resource, ConfigurableListableBeanFactory beanFactory) {
        Executable executable;
        String methodName;
        String name = resource.name();
        if (!StringUtils.hasText((String)name) && (methodName = (executable = parameter.getDeclaringExecutable()).getName()).startsWith("set")) {
            name = Introspector.decapitalize(methodName.substring(3));
        }
        return name;
    }

    @Override
    public void resolve(Parameter parameter, ConfigurableListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        Resource resource = this.getAnnotation(parameter);
        if (resource == null) {
            return;
        }
        Class beanType = resource.type();
        if (Object.class.equals((Object)beanType)) {
            String beanName = this.resolveBeanName(parameter, resource, beanFactory);
            dependentBeanNames.add(beanName);
        } else {
            String[] beanNames;
            for (String name : beanNames = beanFactory.getBeanNamesForType(beanType, false, false)) {
                dependentBeanNames.add(name);
            }
        }
    }
}

