/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory.config;

import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.GenericTypeResolver;

public abstract class GenericBeanPostProcessorAdapter<T>
implements BeanPostProcessor {
    private final Class<T> beanType = GenericTypeResolver.resolveTypeArgument(this.getClass(), GenericBeanPostProcessorAdapter.class);

    public final Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class beanClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (this.beanType.isAssignableFrom(beanClass)) {
            return this.doPostProcessBeforeInitialization(bean, beanName);
        }
        return bean;
    }

    public final Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (this.beanType.isAssignableFrom(beanClass)) {
            return this.doPostProcessAfterInitialization(bean, beanName);
        }
        return bean;
    }

    public final Class<T> getBeanType() {
        return this.beanType;
    }

    protected T doPostProcessBeforeInitialization(T bean, String beanName) throws BeansException {
        this.processBeforeInitialization(bean, beanName);
        return bean;
    }

    protected T doPostProcessAfterInitialization(T bean, String beanName) throws BeansException {
        this.processAfterInitialization(bean, beanName);
        return bean;
    }

    protected void processBeforeInitialization(T bean, String beanName) throws BeansException {
    }

    protected void processAfterInitialization(T bean, String beanName) throws BeansException {
    }
}

