/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory.filter;

import io.microsphere.filter.Filter;
import io.microsphere.spring.util.BeanFactoryUtils;
import io.microsphere.spring.util.BeanRegistrar;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class ResolvableDependencyTypeFilter
implements Filter<Class<?>> {
    public static final String BEAN_NAME = "resolvableDependencyTypeFilter";
    private final Set<Class<?>> resolvableDependencyTypes;

    public ResolvableDependencyTypeFilter(ConfigurableListableBeanFactory beanFactory) {
        this((DefaultListableBeanFactory)beanFactory);
    }

    public ResolvableDependencyTypeFilter(DefaultListableBeanFactory beanFactory) {
        this.resolvableDependencyTypes = BeanFactoryUtils.getResolvableDependencyTypes(beanFactory);
        this.register((SingletonBeanRegistry)beanFactory);
    }

    private void register(SingletonBeanRegistry registry) {
        BeanRegistrar.registerSingleton(registry, BEAN_NAME, this);
    }

    public static ResolvableDependencyTypeFilter getSingleton(BeanFactory beanFactory) {
        return ResolvableDependencyTypeFilter.getSingleton((SingletonBeanRegistry)beanFactory);
    }

    public static ResolvableDependencyTypeFilter getSingleton(SingletonBeanRegistry registry) {
        return (ResolvableDependencyTypeFilter)registry.getSingleton(BEAN_NAME);
    }

    public boolean accept(Class<?> classToFilter) {
        boolean filtered = false;
        for (Class<?> resolvableDependencyType : this.resolvableDependencyTypes) {
            if (!resolvableDependencyType.isAssignableFrom(classToFilter)) continue;
            filtered = true;
            break;
        }
        return filtered;
    }

    public String toString() {
        return "ResolvableDependencyTypeFilter{resolvableDependencyTypes=" + this.resolvableDependencyTypes + '}';
    }
}

