/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cache;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;

public class TTLContext {
    private static final ThreadLocal<Duration> ttlThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R doWithTTL(Function<Duration, R> ttlFunction, Duration defaultTTL) {
        Duration effectiveTTL = TTLContext.getEffectiveTTL(defaultTTL);
        try {
            R r = ttlFunction.apply(effectiveTTL);
            return r;
        }
        finally {
            TTLContext.clearTTL();
        }
    }

    public static void doWithTTL(Consumer<Duration> ttlFunction, Duration defaultTTL) {
        TTLContext.doWithTTL((Duration ttl) -> {
            ttlFunction.accept((Duration)ttl);
            return null;
        }, defaultTTL);
    }

    private static Duration getEffectiveTTL(Duration defaultTTL) {
        Duration ttl = TTLContext.getTTL();
        return ttl == null ? defaultTTL : ttl;
    }

    public static void setTTL(Duration ttl) {
        ttlThreadLocal.set(ttl);
    }

    public static Duration getTTL() {
        return ttlThreadLocal.get();
    }

    public static void clearTTL() {
        ttlThreadLocal.remove();
    }
}

