/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cache.intereptor;

import io.microsphere.collection.MapUtils;
import io.microsphere.spring.cache.TTLContext;
import io.microsphere.spring.cache.annotation.TTLCachePut;
import io.microsphere.spring.cache.annotation.TTLCacheable;
import io.microsphere.spring.context.event.OnceApplicationContextEventListener;
import io.microsphere.spring.util.AnnotationUtils;
import io.microsphere.util.ArrayUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public class TTLCacheResolver
extends OnceApplicationContextEventListener<ContextRefreshedEvent>
implements CacheResolver {
    public static final String BEAN_NAME = "ttlCacheResolver";
    private static final Logger logger = LoggerFactory.getLogger(TTLCacheResolver.class);
    private static final Map<Class<? extends CacheOperation>, Class<? extends Annotation>> ttlAnnotationTypes = MapUtils.of(CacheableOperation.class, TTLCacheable.class, CachePutOperation.class, TTLCachePut.class);
    private Environment environment;
    private Map<String, CacheManager> namedCacheManagersMap;

    public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
        Collection<CacheManager> targetCacheManagers;
        CacheOperation cacheOperation = (CacheOperation)context.getOperation();
        Set cacheNames = cacheOperation.getCacheNames();
        int cacheNamesSize = cacheNames.size();
        if (cacheNamesSize < 1) {
            return Collections.emptyList();
        }
        Map<String, CacheManager> namedCacheManagersMap = this.namedCacheManagersMap;
        int cacheManagersSize = namedCacheManagersMap.size();
        if (cacheManagersSize < 1) {
            return Collections.emptyList();
        }
        int cachesSize = cacheNamesSize * cacheManagersSize;
        ArrayList<Cache> caches = new ArrayList<Cache>(cachesSize);
        AnnotationAttributes ttlAnnotationAttributes = this.getTTLAnnotationAttributes(context, cacheOperation);
        this.setTTL(ttlAnnotationAttributes);
        Object[] cacheManagerBeanNames = ttlAnnotationAttributes.getStringArray("cacheManagers");
        if (ArrayUtils.isEmpty((Object[])cacheManagerBeanNames)) {
            targetCacheManagers = namedCacheManagersMap.values();
        } else {
            targetCacheManagers = new LinkedList<CacheManager>();
            for (Object cacheManagerBeanName : cacheManagerBeanNames) {
                CacheManager cacheManager = namedCacheManagersMap.get(cacheManagerBeanName);
                targetCacheManagers.add(cacheManager);
            }
        }
        for (CacheManager cacheManager : targetCacheManagers) {
            for (String cacheName : cacheNames) {
                Cache cache = cacheManager.getCache(cacheName);
                if (cache == null) continue;
                caches.add(cache);
            }
        }
        return caches;
    }

    private void setTTL(AnnotationAttributes ttlAnnotationAttributes) {
        Duration ttl = this.getTTL(ttlAnnotationAttributes);
        TTLContext.setTTL(ttl);
    }

    private AnnotationAttributes getTTLAnnotationAttributes(CacheOperationInvocationContext<?> context, CacheOperation cacheOperation) {
        Class<?> cacheOperationClass = cacheOperation.getClass();
        Class<? extends Annotation> annotationType = ttlAnnotationTypes.get(cacheOperationClass);
        if (annotationType == null) {
            return null;
        }
        Method method = context.getMethod();
        GenericDeclaration annotatedElement = method;
        AnnotationAttributes attributes = AnnotationUtils.getAnnotationAttributes((AnnotatedElement)annotatedElement, annotationType, (PropertyResolver)this.environment, false, new String[0]);
        if (attributes == null) {
            annotatedElement = context.getTarget() == null ? method.getDeclaringClass() : context.getTarget().getClass();
            attributes = AnnotationUtils.getAnnotationAttributes((AnnotatedElement)annotatedElement, annotationType, (PropertyResolver)this.environment, false, new String[0]);
        }
        return attributes;
    }

    private Duration getTTL(AnnotationAttributes attributes) {
        long expire = (Long)attributes.get((Object)"expire");
        TimeUnit timeUnit = (TimeUnit)((Object)attributes.get((Object)"timeUnit"));
        Duration ttl = Duration.ofMillis(timeUnit.toMillis(expire));
        return ttl;
    }

    @Override
    protected void onApplicationContextEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext();
        this.environment = context.getEnvironment();
        this.namedCacheManagersMap = context.getBeansOfType(CacheManager.class);
    }
}

