/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cache.redis;

import io.microsphere.spring.cache.TTLContext;
import java.time.Duration;
import org.springframework.data.redis.cache.CacheStatistics;
import org.springframework.data.redis.cache.CacheStatisticsCollector;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.lang.Nullable;

public class TTLRedisCacheWriterWrapper
implements RedisCacheWriter {
    private final RedisCacheWriter delegate;

    public TTLRedisCacheWriterWrapper(RedisCacheWriter delegate) {
        this.delegate = delegate;
    }

    public void put(String name, byte[] key, byte[] value, Duration ttl) {
        TTLContext.doWithTTL(effectiveTTL -> this.delegate.put(name, key, value, effectiveTTL), ttl);
    }

    @Nullable
    public byte[] get(String name, byte[] key) {
        return this.delegate.get(name, key);
    }

    @Nullable
    public byte[] putIfAbsent(String name, byte[] key, byte[] value, Duration ttl) {
        return TTLContext.doWithTTL(effectiveTTL -> this.delegate.putIfAbsent(name, key, value, effectiveTTL), ttl);
    }

    public void remove(String name, byte[] key) {
        this.delegate.remove(name, key);
    }

    public void clean(String name, byte[] pattern) {
        this.delegate.clean(name, pattern);
    }

    public void clearStatistics(String name) {
        this.delegate.clearStatistics(name);
    }

    public RedisCacheWriter withStatisticsCollector(CacheStatisticsCollector cacheStatisticsCollector) {
        return this.delegate.withStatisticsCollector(cacheStatisticsCollector);
    }

    public CacheStatistics getCacheStatistics(String cacheName) {
        return this.delegate.getCacheStatistics(cacheName);
    }
}

