/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.cache.redis;

import io.microsphere.reflect.FieldUtils;
import io.microsphere.spring.beans.factory.config.GenericBeanPostProcessorAdapter;
import io.microsphere.spring.cache.redis.TTLRedisCacheWriterWrapper;
import io.microsphere.util.ClassLoaderUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;

public class TTLRedisConfiguration
implements BeanFactoryPostProcessor {
    private static final String REDIS_CACHE_MANAGER_CLASS_NAME = "org.springframework.data.redis.cache.RedisCacheManager";
    private static final boolean REDIS_CACHE_MANAGER_CLASS_PRESENT = ClassLoaderUtils.isPresent((String)"org.springframework.data.redis.cache.RedisCacheManager", (ClassLoader)ClassLoaderUtils.getDefaultClassLoader());

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        boolean present = REDIS_CACHE_MANAGER_CLASS_PRESENT;
        if (!present) {
            present = ClassLoaderUtils.isPresent((String)REDIS_CACHE_MANAGER_CLASS_NAME, (ClassLoader)beanFactory.getBeanClassLoader());
        }
        if (present) {
            beanFactory.addBeanPostProcessor((BeanPostProcessor)new RedisCacheManagerBeanPostProcessor());
        }
    }

    static class RedisCacheManagerBeanPostProcessor
    extends GenericBeanPostProcessorAdapter<RedisCacheManager> {
        RedisCacheManagerBeanPostProcessor() {
        }

        @Override
        protected void processBeforeInitialization(RedisCacheManager bean, String beanName) throws BeansException {
            String fieldName = "cacheWriter";
            RedisCacheWriter redisCacheWriter = io.microsphere.spring.util.FieldUtils.getFieldValue((Object)bean, fieldName, RedisCacheWriter.class);
            if (redisCacheWriter != null) {
                TTLRedisCacheWriterWrapper redisCacheWriterWrapper = new TTLRedisCacheWriterWrapper(redisCacheWriter);
                FieldUtils.setFieldValue((Object)bean, (String)fieldName, (Object)redisCacheWriterWrapper);
            }
        }
    }
}

