/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.config.context.annotation;

import io.microsphere.spring.config.context.annotation.AnnotatedPropertySourceLoader;
import io.microsphere.spring.config.context.annotation.PropertySourceExtensionAttributes;
import io.microsphere.spring.config.env.event.PropertySourceChangedEvent;
import io.microsphere.spring.config.env.event.PropertySourcesChangedEvent;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;

public abstract class PropertySourceExtensionLoader<A extends Annotation, EA extends PropertySourceExtensionAttributes<A>>
extends AnnotatedPropertySourceLoader<A>
implements ApplicationContextAware {
    private final Class<EA> extensionAttributesType = this.resolveExtensionAttributesType();
    private final PathMatcher resourceMatcher = new AntPathMatcher();
    private ApplicationContext context;

    protected Class<EA> resolveExtensionAttributesType() {
        ResolvableType type = ResolvableType.forType(this.getClass());
        ResolvableType superType = type.as(PropertySourceExtensionLoader.class);
        return superType.resolveGeneric(new int[]{1});
    }

    public boolean isResourcePattern(String resourceValue) {
        return this.resourceMatcher.isPattern(resourceValue);
    }

    public final Class<EA> getExtensionAttributesType() {
        return this.extensionAttributesType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final void loadPropertySource(AnnotationAttributes attributes, AnnotationMetadata metadata, String propertySourceName, MutablePropertySources propertySources) throws Throwable {
        ConfigurableEnvironment environment;
        Class<EA> extensionAttributesClass;
        Class annotationType = this.getAnnotationType();
        EA extensionAttributes = this.buildExtensionAttributes(annotationType, extensionAttributesClass = this.getExtensionAttributesType(), attributes, environment = this.getEnvironment());
        PropertySource<?> propertySource = this.loadPropertySource(extensionAttributes, propertySourceName);
        if (propertySource == null) {
            String message = FormatUtils.format((String)"The PropertySources' Resource can't be found by the {} that annotated on {}", (Object[])new Object[]{extensionAttributes, metadata.getClassName()});
            if (!((PropertySourceExtensionAttributes)((Object)extensionAttributes)).isIgnoreResourceNotFound()) throw new IllegalArgumentException(message);
            this.logger.warn(message);
            return;
        } else {
            this.addPropertySource(extensionAttributes, propertySources, propertySource);
        }
    }

    protected void addPropertySource(EA extensionAttributes, MutablePropertySources propertySources, PropertySource<?> propertySource) {
        if (((PropertySourceExtensionAttributes)((Object)extensionAttributes)).isFirstPropertySource()) {
            propertySources.addFirst(propertySource);
        } else {
            String relativePropertySourceName = ((PropertySourceExtensionAttributes)((Object)extensionAttributes)).getAfterPropertySourceName();
            if (org.springframework.util.StringUtils.hasText((String)relativePropertySourceName)) {
                propertySources.addAfter(relativePropertySourceName, propertySource);
            } else {
                relativePropertySourceName = ((PropertySourceExtensionAttributes)((Object)extensionAttributes)).getBeforePropertySourceName();
            }
            if (org.springframework.util.StringUtils.hasText((String)relativePropertySourceName)) {
                propertySources.addBefore(relativePropertySourceName, propertySource);
            } else {
                propertySources.addLast(propertySource);
            }
        }
    }

    protected EA buildExtensionAttributes(Class<A> annotationType, Class<EA> extensionAttributesType, AnnotationAttributes attributes, ConfigurableEnvironment environment) throws Throwable {
        Constructor<EA> constructor = extensionAttributesType.getConstructor(Map.class, Class.class, PropertyResolver.class);
        return (EA)((Object)((PropertySourceExtensionAttributes)((Object)constructor.newInstance(attributes, annotationType, environment))));
    }

    protected final PropertySource<?> loadPropertySource(EA extensionAttributes, String propertySourceName) throws Throwable {
        Comparator<Resource> resourceComparator = this.createResourceComparator(extensionAttributes, propertySourceName);
        List<PropertySourceResource> propertySourceResources = this.resolvePropertySourceResources(extensionAttributes, propertySourceName, resourceComparator);
        int propertySourceResourcesSize = propertySourceResources.size();
        if (propertySourceResourcesSize < 1) {
            return null;
        }
        PropertySourceFactory factory = this.createPropertySourceFactory(extensionAttributes);
        CompositePropertySource compositePropertySource = new CompositePropertySource(propertySourceName);
        for (int i = 0; i < propertySourceResourcesSize; ++i) {
            PropertySourceResource propertySourceResource = propertySourceResources.get(i);
            ResourcePropertySource resourcePropertySource = this.createResourcePropertySource(extensionAttributes, propertySourceName, factory, propertySourceResource);
            compositePropertySource.addPropertySource((PropertySource)resourcePropertySource);
        }
        if (((PropertySourceExtensionAttributes)((Object)extensionAttributes)).isAutoRefreshed()) {
            ResourcePropertySourcesRefresher resourcePropertySourcesRefresher = this.createResourcePropertySourcesRefresher(extensionAttributes, propertySourceName, factory, resourceComparator);
            this.configureResourcePropertySourcesRefresher(extensionAttributes, propertySourceResources, compositePropertySource, resourcePropertySourcesRefresher);
        }
        return compositePropertySource;
    }

    private ResourcePropertySourcesRefresher createResourcePropertySourcesRefresher(EA extensionAttributes, String propertySourceName, PropertySourceFactory factory, Comparator<Resource> resourceComparator) throws Throwable {
        return (resourceValue, resource) -> {
            CompositePropertySource compositePropertySource = this.getPropertySource(propertySourceName);
            if (compositePropertySource == null) {
                return;
            }
            LinkedList<PropertySourceChangedEvent> subEvents = new LinkedList<PropertySourceChangedEvent>();
            if (resource == null) {
                this.refreshPropertySources(extensionAttributes, propertySourceName, factory, resourceComparator, resourceValue, compositePropertySource, subEvents);
            } else {
                this.refreshPropertySources(extensionAttributes, propertySourceName, factory, resourceComparator, resourceValue, resource, compositePropertySource, subEvents);
            }
            this.publishPropertySourcesChangedEvent(subEvents);
        };
    }

    private void publishPropertySourcesChangedEvent(List<PropertySourceChangedEvent> subEvents) {
        PropertySourcesChangedEvent propertySourcesChangedEvent = new PropertySourcesChangedEvent(this.context, subEvents);
        this.context.publishEvent((ApplicationEvent)propertySourcesChangedEvent);
    }

    private void refreshPropertySources(EA extensionAttributes, String propertySourceName, PropertySourceFactory factory, Comparator<Resource> resourceComparator, String resourceValue, CompositePropertySource compositePropertySource, List<PropertySourceChangedEvent> subEvents) throws Throwable {
        List<PropertySourceResource> propertySourceResources = this.resolvePropertySourceResources(extensionAttributes, propertySourceName, resourceValue, resourceComparator);
        int propertySourceResourcesSize = propertySourceResources.size();
        if (propertySourceResourcesSize < 1) {
            return;
        }
        List<ResourcePropertySource> resourcePropertySources = this.getResourcePropertySources(compositePropertySource);
        ArrayList<ResourcePropertySource> newResourcePropertySources = new ArrayList<ResourcePropertySource>(propertySourceResourcesSize);
        for (int i = 0; i < propertySourceResourcesSize; ++i) {
            PropertySourceResource propertySourceResource = propertySourceResources.get(i);
            ResourcePropertySource newResourcePropertySource = this.createResourcePropertySource(extensionAttributes, propertySourceName, factory, propertySourceResource);
            newResourcePropertySources.add(newResourcePropertySource);
        }
        this.updateResourcePropertySources(newResourcePropertySources, resourcePropertySources, subEvents);
        this.updatePropertySources(propertySourceName, resourcePropertySources);
    }

    private void refreshPropertySources(EA extensionAttributes, String propertySourceName, PropertySourceFactory factory, Comparator<Resource> resourceComparator, String resourceValue, Resource resource, CompositePropertySource compositePropertySource, List<PropertySourceChangedEvent> subEvents) throws Throwable {
        PropertySourceResource propertySourceResource = this.createPropertySourceResource(resourceValue, resource, resourceComparator);
        ResourcePropertySource newResourcePropertySource = this.createResourcePropertySource(extensionAttributes, propertySourceName, factory, propertySourceResource);
        List<ResourcePropertySource> resourcePropertySources = this.getResourcePropertySources(compositePropertySource);
        this.updateResourcePropertySources(Collections.singleton(newResourcePropertySource), resourcePropertySources, subEvents);
        this.updatePropertySources(propertySourceName, resourcePropertySources);
    }

    private void updatePropertySources(String propertySourceName, List<ResourcePropertySource> resourcePropertySources) {
        Collections.sort(resourcePropertySources);
        CompositePropertySource newCompositePropertySource = new CompositePropertySource(propertySourceName);
        resourcePropertySources.forEach(arg_0 -> ((CompositePropertySource)newCompositePropertySource).addPropertySource(arg_0));
        MutablePropertySources propertySources = this.getPropertySources();
        propertySources.replace(propertySourceName, (PropertySource)newCompositePropertySource);
    }

    private void updateResourcePropertySources(Iterable<ResourcePropertySource> newResourcePropertySources, List<ResourcePropertySource> resourcePropertySources, List<PropertySourceChangedEvent> subEvents) {
        for (ResourcePropertySource newResourcePropertySource : newResourcePropertySources) {
            String newResourcePropertySourceName = newResourcePropertySource.getName();
            Iterator<ResourcePropertySource> iterator = resourcePropertySources.iterator();
            boolean addedSubEvent = false;
            while (iterator.hasNext()) {
                ResourcePropertySource resourcePropertySource = iterator.next();
                if (!newResourcePropertySourceName.equals(resourcePropertySource.getName())) continue;
                subEvents.add(PropertySourceChangedEvent.replaced(this.context, (PropertySource)newResourcePropertySource, (PropertySource)resourcePropertySource));
                addedSubEvent = true;
                iterator.remove();
            }
            if (!addedSubEvent) {
                subEvents.add(PropertySourceChangedEvent.added(this.context, (PropertySource)newResourcePropertySource));
            }
            resourcePropertySources.add(newResourcePropertySource);
        }
    }

    private void updateResourcePropertySources(ResourcePropertySource newResourcePropertySource, List<ResourcePropertySource> resourcePropertySources, List<PropertySourceChangedEvent> subEvents) {
        String newResourcePropertySourceName = newResourcePropertySource.getName();
        Iterator<ResourcePropertySource> iterator = resourcePropertySources.iterator();
        LinkedList<ResourcePropertySource> oldResourcePropertySources = new LinkedList<ResourcePropertySource>();
        while (iterator.hasNext()) {
            ResourcePropertySource resourcePropertySource = iterator.next();
            if (!newResourcePropertySourceName.equals(resourcePropertySource.getName())) continue;
            oldResourcePropertySources.add(resourcePropertySource);
            iterator.remove();
        }
        resourcePropertySources.add(newResourcePropertySource);
    }

    private List<ResourcePropertySource> getResourcePropertySources(CompositePropertySource compositePropertySource) {
        Collection propertySources = compositePropertySource.getPropertySources();
        ArrayList<ResourcePropertySource> resourcePropertySources = new ArrayList<ResourcePropertySource>(propertySources.size());
        propertySources.stream().map(ResourcePropertySource.class::cast).forEach(resourcePropertySources::add);
        return resourcePropertySources;
    }

    private CompositePropertySource getPropertySource(String propertySourceName) {
        MutablePropertySources propertySources = this.getPropertySources();
        PropertySource propertySource = propertySources.get(propertySourceName);
        if (propertySource instanceof CompositePropertySource) {
            return (CompositePropertySource)propertySource;
        }
        this.logger.warn("The CompositePropertySource can't be found by the name : {} , actual : {}", (Object)propertySourceName, (Object)propertySource);
        return null;
    }

    private List<PropertySourceResource> resolvePropertySourceResources(EA extensionAttributes, String propertySourceName, Comparator<Resource> resourceComparator) throws Throwable {
        Object[] resourceValues = ((PropertySourceExtensionAttributes)((Object)extensionAttributes)).getValue();
        boolean ignoreResourceNotFound = ((PropertySourceExtensionAttributes)((Object)extensionAttributes)).isIgnoreResourceNotFound();
        if (ObjectUtils.isEmpty((Object[])resourceValues)) {
            if (ignoreResourceNotFound) {
                return Collections.emptyList();
            }
            throw new IllegalArgumentException("The 'value' attribute must be present at the annotation : @" + this.getAnnotationType().getName());
        }
        LinkedList<PropertySourceResource> propertySourceResources = new LinkedList<PropertySourceResource>();
        for (Object resourceValue : resourceValues) {
            propertySourceResources.addAll(this.resolvePropertySourceResources(extensionAttributes, propertySourceName, (String)resourceValue, resourceComparator));
        }
        Collections.sort(propertySourceResources);
        return propertySourceResources;
    }

    protected List<PropertySourceResource> resolvePropertySourceResources(EA extensionAttributes, String propertySourceName, String resourceValue, Comparator<Resource> resourceComparator) throws Throwable {
        Resource[] resources;
        block6: {
            boolean ignoreResourceNotFound = ((PropertySourceExtensionAttributes)((Object)extensionAttributes)).isIgnoreResourceNotFound();
            resources = null;
            try {
                resources = this.resolveResources(extensionAttributes, propertySourceName, resourceValue);
            }
            finally {
                if (resources == null) {
                }
                break block6;
            }
            return Collections.emptyList();
        }
        int length = resources.length;
        ArrayList<PropertySourceResource> propertySourceResources = new ArrayList<PropertySourceResource>(length);
        for (int i = 0; i < length; ++i) {
            Resource resource = resources[i];
            PropertySourceResource propertySourceResource = this.createPropertySourceResource(resourceValue, resource, resourceComparator);
            propertySourceResources.add(propertySourceResource);
        }
        return propertySourceResources;
    }

    private MutablePropertySources getPropertySources() {
        return this.getEnvironment().getPropertySources();
    }

    @NonNull
    protected PropertySourceFactory createPropertySourceFactory(EA extensionAttributes) {
        return (PropertySourceFactory)this.createInstance(extensionAttributes, PropertySourceExtensionAttributes::getPropertySourceFactoryClass);
    }

    @NonNull
    protected Comparator<Resource> createResourceComparator(EA extensionAttributes, String propertySourceName) {
        return (Comparator)this.createInstance(extensionAttributes, PropertySourceExtensionAttributes::getResourceComparatorClass);
    }

    private PropertySourceResource createPropertySourceResource(String resourceValue, Resource resource, Comparator<Resource> resourceComparator) {
        return new PropertySourceResource(resourceValue, resource, resourceComparator);
    }

    protected String createResourcePropertySourceName(String propertySourceName, String resourceValue, Resource resource) {
        Object suffix = resource.toString() == null ? Integer.valueOf(resource.hashCode()) : resource.toString();
        return propertySourceName + "#" + resourceValue + "@" + suffix;
    }

    protected final ResourcePropertySource createResourcePropertySource(EA extensionAttributes, String propertySourceName, PropertySourceFactory factory, PropertySourceResource propertySourceResource) throws Throwable {
        String resourceValue = propertySourceResource.resourceValue;
        Resource resource = propertySourceResource.resource;
        String encoding = ((PropertySourceExtensionAttributes)((Object)extensionAttributes)).getEncoding();
        EncodedResource encodedResource = new EncodedResource(resource, encoding);
        String name = this.createResourcePropertySourceName(propertySourceName, resourceValue, resource);
        PropertySource propertySource = factory.createPropertySource(name, encodedResource);
        return new ResourcePropertySource(propertySourceResource, propertySource);
    }

    protected void configureResourcePropertySourcesRefresher(EA extensionAttributes, List<PropertySourceResource> propertySourceResources, CompositePropertySource propertySource, ResourcePropertySourcesRefresher refresher) throws Throwable {
    }

    @Nullable
    protected abstract Resource[] resolveResources(EA var1, String var2, String var3) throws Throwable;

    protected <T> T createInstance(EA extensionAttributes, Function<EA, Class<T>> classFunction) {
        Class<T> type = classFunction.apply(extensionAttributes);
        return (T)BeanUtils.instantiateClass(type);
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @FunctionalInterface
    protected static interface ResourcePropertySourcesRefresher {
        public void refresh(String var1, @Nullable Resource var2) throws Throwable;

        default public void refresh(String resourceValue) throws Throwable {
            this.refresh(resourceValue, null);
        }
    }

    private static class ResourcePropertySource<T>
    extends EnumerablePropertySource<T>
    implements Comparable<ResourcePropertySource<T>> {
        private final PropertySourceResource propertySourceResource;
        private final PropertySource<T> original;
        private final EnumerablePropertySource<T> enumerablePropertySource;

        public ResourcePropertySource(PropertySourceResource propertySourceResource, PropertySource<T> original) {
            super(original.getName(), original.getSource());
            this.propertySourceResource = propertySourceResource;
            this.original = original;
            this.enumerablePropertySource = original instanceof EnumerablePropertySource ? (EnumerablePropertySource)original : null;
        }

        public String[] getPropertyNames() {
            if (this.enumerablePropertySource == null) {
                return StringUtils.EMPTY_STRING_ARRAY;
            }
            return this.enumerablePropertySource.getPropertyNames();
        }

        public Object getProperty(String name) {
            if (this.enumerablePropertySource == null) {
                return null;
            }
            return this.enumerablePropertySource.getProperty(name);
        }

        public String getResourceValue() {
            return this.propertySourceResource.resourceValue;
        }

        public Resource getResource() {
            return this.propertySourceResource.resource;
        }

        public PropertySource<T> getOriginal() {
            return this.original;
        }

        @Override
        public int compareTo(ResourcePropertySource<T> o) {
            return this.propertySourceResource.compareTo(o.propertySourceResource);
        }
    }

    protected static class PropertySourceResource
    implements Comparable<PropertySourceResource> {
        private final String resourceValue;
        private final Resource resource;
        private final Comparator<Resource> resourceComparator;

        public PropertySourceResource(String resourceValue, Resource resource, Comparator<Resource> resourceComparator) {
            this.resourceValue = resourceValue;
            this.resource = resource;
            this.resourceComparator = resourceComparator;
        }

        public String getResourceValue() {
            return this.resourceValue;
        }

        public Resource getResource() {
            return this.resource;
        }

        @Override
        public int compareTo(PropertySourceResource o) {
            return this.resourceComparator.compare(this.resource, o.resource);
        }
    }
}

