/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.config.context.annotation;

import io.microsphere.io.StandardFileWatchService;
import io.microsphere.io.event.FileChangedEvent;
import io.microsphere.io.event.FileChangedListener;
import io.microsphere.spring.config.context.annotation.PropertySourceExtensionAttributes;
import io.microsphere.spring.config.context.annotation.PropertySourceExtensionLoader;
import io.microsphere.spring.config.context.annotation.ResourcePropertySource;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.PropertySourceFactory;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ResourcePropertySourceLoader
extends PropertySourceExtensionLoader<ResourcePropertySource, PropertySourceExtensionAttributes<ResourcePropertySource>>
implements ResourceLoaderAware,
BeanClassLoaderAware,
DisposableBean {
    private ResourcePatternResolver resourcePatternResolver;
    private StandardFileWatchService fileWatchService;

    @Override
    protected Resource[] resolveResources(PropertySourceExtensionAttributes<ResourcePropertySource> extensionAttributes, String propertySourceName, String resourceValue) throws Throwable {
        ResourcePatternResolver resourcePatternResolver = this.resourcePatternResolver;
        if (resourcePatternResolver == null) {
            this.resourcePatternResolver = resourcePatternResolver = new PathMatchingResourcePatternResolver(this.getResourceLoader());
        }
        return resourcePatternResolver.getResources(resourceValue);
    }

    @Override
    protected void configureResourcePropertySourcesRefresher(PropertySourceExtensionAttributes<ResourcePropertySource> extensionAttributes, List<PropertySourceExtensionLoader.PropertySourceResource> propertySourceResources, CompositePropertySource propertySource, PropertySourceExtensionLoader.ResourcePropertySourcesRefresher refresher) throws Throwable {
        this.fileWatchService = new StandardFileWatchService();
        int size = propertySourceResources.size();
        ListenerAdapter listenerAdapter = new ListenerAdapter(refresher, size);
        for (int i = 0; i < size; ++i) {
            PropertySourceExtensionLoader.PropertySourceResource propertySourceResource = propertySourceResources.get(i);
            Resource resource = propertySourceResource.getResource();
            if (!this.isFileSystemBasedResource(resource)) continue;
            File resourceFile = resource.getFile();
            listenerAdapter.register(resourceFile, propertySourceResource.getResourceValue());
            this.fileWatchService.watch(resourceFile, (FileChangedListener)listenerAdapter, new FileChangedEvent.Kind[]{FileChangedEvent.Kind.MODIFIED});
        }
        this.fileWatchService.start();
    }

    private boolean isFileSystemBasedResource(Resource resource) {
        return resource instanceof FileSystemResource || resource instanceof FileUrlResource;
    }

    public void destroy() throws Exception {
        if (this.fileWatchService != null) {
            this.fileWatchService.stop();
        }
    }

    class Listener
    implements FileChangedListener {
        private final PropertySourceExtensionAttributes<ResourcePropertySource> extensionAttributes;
        private final CompositePropertySource compositePropertySource;
        private final Comparator<Resource> resourceComparator;
        private final PropertySourceFactory factory;

        Listener(PropertySourceExtensionAttributes<ResourcePropertySource> extensionAttributes, CompositePropertySource propertySource, Comparator<Resource> resourceComparator, PropertySourceFactory factory) {
            this.extensionAttributes = extensionAttributes;
            this.compositePropertySource = propertySource;
            this.resourceComparator = resourceComparator;
            this.factory = factory;
        }

        public void onFileModified(FileChangedEvent event) {
            ConfigurableEnvironment environment = ResourcePropertySourceLoader.this.getEnvironment();
            MutablePropertySources propertySources = environment.getPropertySources();
            File resourceFile = event.getFile();
            FileSystemResource resource = new FileSystemResource(resourceFile);
            String encoding = this.extensionAttributes.getEncoding();
            EncodedResource encodedResource = new EncodedResource((Resource)resource, encoding);
            String propertySourceName = resourceFile.getAbsolutePath();
            try {
                PropertySource propertySource = this.factory.createPropertySource(propertySourceName, encodedResource);
                propertySources.addFirst(propertySource);
            }
            catch (IOException e) {
                ResourcePropertySourceLoader.this.logger.error("TODO message", (Throwable)e);
            }
        }
    }

    class ListenerAdapter
    implements FileChangedListener {
        private final PropertySourceExtensionLoader.ResourcePropertySourcesRefresher refresher;
        private final Map<File, String> fileToResourceValues;

        ListenerAdapter(PropertySourceExtensionLoader.ResourcePropertySourcesRefresher refresher, int initialCapacity) {
            this.refresher = refresher;
            this.fileToResourceValues = new HashMap<File, String>(initialCapacity);
        }

        public void register(File file, String resourceValue) {
            this.fileToResourceValues.put(file, resourceValue);
        }

        public void onFileModified(FileChangedEvent event) {
            File resourceFile = event.getFile();
            String resourceValue = this.fileToResourceValues.get(resourceFile);
            if (resourceValue != null) {
                FileSystemResource resource = new FileSystemResource(resourceFile);
                try {
                    this.refresher.refresh(resourceValue, (Resource)resource);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

