/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.config.context.annotation;

import io.microsphere.spring.config.context.annotation.AnnotatedPropertySourceLoader;
import io.microsphere.spring.config.context.annotation.ResourcePropertySourceLoader;
import io.microsphere.spring.config.context.annotation.ResourcePropertySources;
import io.microsphere.spring.core.annotation.GenericAnnotationAttributes;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.type.AnnotationMetadata;

class ResourcePropertySourcesLoader
extends AnnotatedPropertySourceLoader<ResourcePropertySources>
implements ResourceLoaderAware,
BeanClassLoaderAware {
    ResourcePropertySourcesLoader() {
    }

    @Override
    protected void loadPropertySource(AnnotationAttributes attributes, AnnotationMetadata metadata, String propertySourceName, MutablePropertySources propertySources) throws Throwable {
        AnnotationAttributes[] annotationAttributesArray = attributes.getAnnotationArray("value");
        Set<AnnotationAttributes> attributesSet = GenericAnnotationAttributes.ofSet(annotationAttributesArray);
        ResourcePropertySourceLoader delegate = this.getDelegate();
        for (AnnotationAttributes elementAttributes : attributesSet) {
            String name = this.resolvePropertySourceName(elementAttributes, metadata);
            delegate.loadPropertySource(elementAttributes, metadata, name, propertySources);
        }
    }

    private ResourcePropertySourceLoader getDelegate() {
        ResourcePropertySourceLoader delegate = new ResourcePropertySourceLoader();
        delegate.setEnvironment((Environment)this.getEnvironment());
        delegate.setBeanFactory((BeanFactory)this.getBeanFactory());
        delegate.setResourceLoader(this.getResourceLoader());
        delegate.setBeanClassLoader(this.getClassLoader());
        return delegate;
    }
}

