/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.config.env.event;

import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.core.env.PropertySource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PropertySourceChangedEvent
extends ApplicationContextEvent {
    private final Kind kind;
    private final PropertySource newPropertySource;
    private final PropertySource oldPropertySource;

    protected PropertySourceChangedEvent(ApplicationContext source, Kind kind, @Nullable PropertySource newPropertySource, @Nullable PropertySource oldPropertySource) {
        super(source);
        this.kind = kind;
        this.newPropertySource = newPropertySource;
        this.oldPropertySource = oldPropertySource;
    }

    protected PropertySourceChangedEvent(ApplicationContext source, Kind kind, @Nullable PropertySource newPropertySource) {
        this(source, kind, newPropertySource, null);
    }

    @Nullable
    public PropertySource getNewPropertySource() {
        return this.newPropertySource;
    }

    @Nullable
    public PropertySource getOldPropertySource() {
        return this.oldPropertySource;
    }

    public Kind getKind() {
        return this.kind;
    }

    public static PropertySourceChangedEvent added(ApplicationContext source, @NonNull PropertySource newPropertySource) {
        Assert.notNull((Object)newPropertySource, (String)"The 'newPropertySource' must not be null!");
        return new PropertySourceChangedEvent(source, Kind.ADDED, newPropertySource);
    }

    public static PropertySourceChangedEvent replaced(ApplicationContext source, @NonNull PropertySource newPropertySource, @NonNull PropertySource oldPropertySource) {
        Assert.notNull((Object)newPropertySource, (String)"The 'newPropertySource' must not be null!");
        Assert.notNull((Object)oldPropertySource, (String)"The 'oldPropertySource' must not be null!");
        return new PropertySourceChangedEvent(source, Kind.REPLACED, newPropertySource, oldPropertySource);
    }

    public static PropertySourceChangedEvent removed(ApplicationContext source, @NonNull PropertySource oldPropertySource) {
        Assert.notNull((Object)oldPropertySource, (String)"The 'oldPropertySource' must not be null!");
        return new PropertySourceChangedEvent(source, Kind.REMOVED, null, oldPropertySource);
    }

    public static enum Kind {
        ADDED,
        REPLACED,
        REMOVED;

    }
}

