/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.spring.beans.factory.config.NamedBeanHolderComparator;
import io.microsphere.spring.context.event.BeanFactoryListener;
import io.microsphere.spring.context.event.BeanListeners;
import io.microsphere.spring.util.SpringFactoriesLoaderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.NamedBeanHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

class BeanFactoryListeners
implements BeanFactoryListener {
    private static final Logger logger = LoggerFactory.getLogger(BeanListeners.class);
    private static final String BEAN_NAME = "beanFactoryListeners";
    private final List<NamedBeanHolder<BeanFactoryListener>> namedListeners;
    private final int listenerCount;

    public BeanFactoryListeners(ConfigurableListableBeanFactory beanFactory) {
        this.namedListeners = this.getBeanDefinitionListeners(beanFactory);
        this.listenerCount = this.namedListeners.size();
    }

    private List<NamedBeanHolder<BeanFactoryListener>> getBeanDefinitionListeners(ConfigurableListableBeanFactory beanFactory) {
        SpringFactoriesLoaderUtils.registerFactories((BeanFactory)beanFactory, BeanFactoryListener.class);
        Map beanDefinitionListenersMap = beanFactory.getBeansOfType(BeanFactoryListener.class);
        ArrayList<NamedBeanHolder<BeanFactoryListener>> namedListeners = new ArrayList<NamedBeanHolder<BeanFactoryListener>>(beanDefinitionListenersMap.size());
        for (Map.Entry entry : beanDefinitionListenersMap.entrySet()) {
            NamedBeanHolder namedListener = new NamedBeanHolder((String)entry.getKey(), (Object)((BeanFactoryListener)entry.getValue()));
            namedListeners.add((NamedBeanHolder<BeanFactoryListener>)namedListener);
        }
        namedListeners.sort(NamedBeanHolderComparator.INSTANCE);
        return namedListeners;
    }

    @Override
    public void onBeanDefinitionRegistryReady(BeanDefinitionRegistry registry) {
        this.iterate(listener -> listener.onBeanDefinitionRegistryReady(registry), "onBeanDefinitionRegistryReady");
    }

    @Override
    public void onBeanFactoryReady(ConfigurableListableBeanFactory beanFactory) {
        this.iterate(listener -> listener.onBeanFactoryReady(beanFactory), "onBeanFactoryReady");
    }

    @Override
    public void onBeanFactoryConfigurationFrozen(ConfigurableListableBeanFactory beanFactory) {
        this.iterate(listener -> listener.onBeanFactoryConfigurationFrozen(beanFactory), "onBeanFactoryConfigurationFrozen");
    }

    private void iterate(Consumer<BeanFactoryListener> listenerConsumer, String action) {
        for (int i = 0; i < this.listenerCount; ++i) {
            NamedBeanHolder<BeanFactoryListener> namedListener = this.namedListeners.get(i);
            BeanFactoryListener listener = (BeanFactoryListener)namedListener.getBeanInstance();
            String listenerBeanName = namedListener.getBeanName();
            try {
                listenerConsumer.accept(listener);
                logger.trace("BeanDefinitionListener[name : '{}' , order : {}] execution {} -> '{}'", new Object[]{listenerBeanName, listener, i, action});
                continue;
            }
            catch (Throwable e) {
                logger.error("BeanDefinitionListener[name : '{}' , order : {}] execution {} -> '{}' failed", new Object[]{listenerBeanName, listener, i, action, e});
            }
        }
    }

    void registerBean(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(BeanFactoryListeners.class, () -> this);
        beanDefinitionBuilder.setPrimary(true);
        registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    static BeanFactoryListeners getBean(BeanFactory beanFactory) {
        return (BeanFactoryListeners)beanFactory.getBean(BEAN_NAME, BeanFactoryListeners.class);
    }
}

