/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.spring.context.event.ApplicationEventInterceptor;
import io.microsphere.spring.context.event.ApplicationEventInterceptorChain;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.ResolvableType;

class DefaultApplicationEventInterceptorChain
implements ApplicationEventInterceptorChain {
    private final Iterator<ApplicationEventInterceptor> iterator;
    private final BiConsumer<ApplicationEvent, ResolvableType> eventAndTypeConsumer;

    public DefaultApplicationEventInterceptorChain(Iterable<ApplicationEventInterceptor> interceptors, BiConsumer<ApplicationEvent, ResolvableType> eventAndTypeConsumer) {
        this.iterator = interceptors.iterator();
        this.eventAndTypeConsumer = eventAndTypeConsumer;
    }

    @Override
    public void intercept(ApplicationEvent event, ResolvableType eventType) {
        if (this.iterator.hasNext()) {
            ApplicationEventInterceptor interceptor = this.iterator.next();
            interceptor.intercept(event, eventType, this);
            return;
        }
        this.eventAndTypeConsumer.accept(event, eventType);
    }
}

