/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.spring.context.event.BeanFactoryListeners;
import io.microsphere.spring.context.event.BeanListeners;
import io.microsphere.spring.context.event.EventPublishingBeanAfterProcessor;
import io.microsphere.spring.util.BeanRegistrar;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;

class EventPublishingBeanBeforeProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanDefinitionRegistryPostProcessor,
DestructionAwareBeanPostProcessor,
InstantiationStrategy {
    private BeanDefinitionRegistry registry;
    private InstantiationStrategy instantiationStrategyDelegate;
    private BeanListeners beanEventListeners;
    private BeanFactoryListeners beanFactoryListeners;

    EventPublishingBeanBeforeProcessor() {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
        this.registerBeanFactoryListeners(registry);
        this.prepareBeanDefinitions(registry);
        this.fireBeanDefinitionRegistryReadyEvent(registry);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.fireBeanFactoryReadyEvent(beanFactory);
        this.registerBeanEventListeners(beanFactory);
        this.decorateInstantiationStrategy(beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)this);
    }

    public Object instantiate(RootBeanDefinition bd, String beanName, BeanFactory owner) throws BeansException {
        return this.aroundInstantiate(beanName, bd, () -> this.instantiationStrategyDelegate.instantiate(bd, beanName, owner));
    }

    public Object instantiate(RootBeanDefinition bd, String beanName, BeanFactory owner, Constructor<?> ctor, Object ... args) throws BeansException {
        return this.aroundInstantiate(beanName, bd, () -> this.instantiationStrategyDelegate.instantiate(bd, beanName, owner, ctor, args));
    }

    public Object instantiate(RootBeanDefinition bd, String beanName, BeanFactory owner, Object factoryBean, Method factoryMethod, Object ... args) throws BeansException {
        return this.aroundInstantiate(beanName, bd, () -> this.instantiationStrategyDelegate.instantiate(bd, beanName, owner, factoryBean, factoryMethod, args));
    }

    private Object aroundInstantiate(String beanName, RootBeanDefinition mergedBeanDefinition, Supplier<Object> beanSupplier) {
        this.beanEventListeners.onBeforeBeanInstantiate(beanName, mergedBeanDefinition);
        Object bean = beanSupplier.get();
        this.beanEventListeners.onAfterBeanInstantiated(beanName, mergedBeanDefinition, bean);
        return bean;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        this.beanEventListeners.onBeanPropertyValuesReady(beanName, bean, pvs);
        return pvs;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.beanEventListeners.onBeforeBeanInitialize(beanName, bean);
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        this.beanEventListeners.onBeforeBeanDestroy(beanName, bean);
    }

    private void prepareBeanDefinitions(BeanDefinitionRegistry registry) {
        String[] beanNames = registry.getBeanDefinitionNames();
        int length = beanNames.length;
        ArrayList<BeanDefinitionHolder> beanDefinitionHolders = new ArrayList<BeanDefinitionHolder>(length);
        for (int i = 0; i < length; ++i) {
            String beanName = beanNames[i];
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            beanDefinitionHolders.add(new BeanDefinitionHolder(beanDefinition, beanName));
            registry.removeBeanDefinition(beanName);
        }
        BeanRegistrar.registerBeanDefinition(registry, EventPublishingBeanAfterProcessor.Initializer.class);
        beanDefinitionHolders.forEach(beanDefinitionHolder -> BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)beanDefinitionHolder, (BeanDefinitionRegistry)registry));
    }

    private void fireBeanDefinitionRegistryReadyEvent(BeanDefinitionRegistry registry) {
        this.beanFactoryListeners.onBeanDefinitionRegistryReady(registry);
    }

    private void fireBeanFactoryReadyEvent(ConfigurableListableBeanFactory beanFactory) {
        this.beanFactoryListeners.onBeanFactoryReady(beanFactory);
    }

    private void registerBeanFactoryListeners(BeanDefinitionRegistry registry) {
        if (registry instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory beanFactory = (ConfigurableListableBeanFactory)registry;
            BeanFactoryListeners beanFactoryListeners = new BeanFactoryListeners(beanFactory);
            beanFactoryListeners.registerBean(registry);
            this.beanFactoryListeners = beanFactoryListeners;
        }
    }

    private void registerBeanEventListeners(ConfigurableListableBeanFactory context) {
        BeanListeners beanEventListeners = new BeanListeners(context);
        beanEventListeners.registerBean(this.registry);
        this.beanEventListeners = beanEventListeners;
    }

    private void decorateInstantiationStrategy(ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory instanceof AbstractAutowireCapableBeanFactory) {
            this.instantiationStrategyDelegate = this.getInstantiationStrategyDelegate(beanFactory);
            if (this.instantiationStrategyDelegate != this) {
                AbstractAutowireCapableBeanFactory autowireCapableBeanFactory = (AbstractAutowireCapableBeanFactory)beanFactory;
                autowireCapableBeanFactory.setInstantiationStrategy((InstantiationStrategy)this);
            }
        }
    }

    private InstantiationStrategy getInstantiationStrategyDelegate(ConfigurableListableBeanFactory beanFactory) {
        InstantiationStrategy instantiationStrategy = null;
        try {
            Method method = AbstractAutowireCapableBeanFactory.class.getDeclaredMethod("getInstantiationStrategy", new Class[0]);
            method.setAccessible(true);
            instantiationStrategy = (InstantiationStrategy)method.invoke((Object)beanFactory, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return instantiationStrategy;
    }
}

