/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.spring.context.event.ApplicationListenerInterceptor;
import io.microsphere.spring.context.event.DefaultApplicationListenerInterceptorChain;
import java.util.List;
import java.util.Objects;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.context.event.GenericApplicationListenerAdapter;
import org.springframework.core.ResolvableType;

class InterceptingApplicationListener
implements GenericApplicationListener {
    private final ApplicationListener<?> delegate;
    private final GenericApplicationListener smartListener;
    private final List<ApplicationListenerInterceptor> interceptors;

    InterceptingApplicationListener(ApplicationListener<?> delegate, List<ApplicationListenerInterceptor> interceptors) {
        this.delegate = delegate;
        this.smartListener = delegate instanceof GenericApplicationListener ? (GenericApplicationListener)delegate : new GenericApplicationListenerAdapter(delegate);
        this.interceptors = interceptors;
    }

    public boolean supportsEventType(ResolvableType eventType) {
        return this.smartListener.supportsEventType(eventType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        DefaultApplicationListenerInterceptorChain chain = new DefaultApplicationListenerInterceptorChain(this.interceptors, this::onEvent);
        chain.intercept(this.delegate, event);
    }

    private void onEvent(ApplicationListener applicationListener, ApplicationEvent event) {
        applicationListener.onApplicationEvent(event);
    }

    public ApplicationListener<?> getDelegate() {
        ApplicationListener<?> delegate = this.delegate;
        while (delegate instanceof InterceptingApplicationListener) {
            delegate = ((InterceptingApplicationListener)delegate).delegate;
        }
        return delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterceptingApplicationListener that = (InterceptingApplicationListener)o;
        return this.getDelegate().equals(that.getDelegate());
    }

    public int hashCode() {
        return Objects.hash(this.getDelegate());
    }
}

