/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class OnceApplicationContextEventListener<E extends ApplicationContextEvent>
implements ApplicationListener<E>,
ApplicationContextAware {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;

    public OnceApplicationContextEventListener() {
    }

    public OnceApplicationContextEventListener(ApplicationContext applicationContext) {
        this.setApplicationContext(applicationContext);
    }

    public final void onApplicationEvent(E event) {
        if (this.isOriginalEventSource((ApplicationEvent)event)) {
            this.onApplicationContextEvent(event);
        }
    }

    protected abstract void onApplicationContextEvent(E var1);

    private boolean isOriginalEventSource(ApplicationEvent event) {
        boolean originalEventSource = ObjectUtils.nullSafeEquals((Object)this.getApplicationContext(), (Object)event.getSource());
        if (!originalEventSource && this.log.isDebugEnabled()) {
            this.log.debug((Object)("The source of event[" + event.getSource() + "] is not original!"));
        }
        return originalEventSource;
    }

    public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            throw new NullPointerException("applicationContext must be not null, it has to invoke setApplicationContext(ApplicationContext) method first if " + ClassUtils.getShortName(this.getClass()) + " instance is not a Spring Bean");
        }
        return this.applicationContext;
    }
}

