/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.collection.ListUtils;
import io.microsphere.lang.function.ThrowableSupplier;
import io.microsphere.spring.beans.factory.DefaultBeanDependencyResolver;
import io.microsphere.spring.context.event.BeanFactoryListenerAdapter;
import io.microsphere.spring.util.BeanFactoryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

public class ParallelPreInstantiationSingletonsBeanFactoryListener
extends BeanFactoryListenerAdapter
implements EnvironmentAware,
BeanFactoryAware {
    public static final String THREADS_PROPERTY_NAME = "microsphere.spring.pre-instantiation.singletons.threads";
    public static final String THREAD_NAME_PREFIX_PROPERTY_NAME = "microsphere.spring.pre-instantiation.singletons.thread.name-prefix";
    public static final String DEFAULT_THREAD_NAME_PREFIX = "Parallel-Pre-Instantiation-Singletons-Thread-";
    private static final Logger logger = LoggerFactory.getLogger(ParallelPreInstantiationSingletonsBeanFactoryListener.class);
    private Environment environment;
    private DefaultListableBeanFactory beanFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBeanFactoryConfigurationFrozen(ConfigurableListableBeanFactory bf) {
        DefaultListableBeanFactory beanFactory = this.beanFactory;
        if (bf != beanFactory) {
            logger.warn("Current BeanFactory[{}] is not a instance of DefaultListableBeanFactory", (Object)bf);
            return;
        }
        StopWatch stopWatch = new StopWatch("ParallelPreInstantiationSingletons");
        ExecutorService executorService = this.newExecutorService();
        if (executorService != null) {
            try {
                Map<String, Set<String>> dependentBeanNamesMap = this.resolveDependentBeanNamesMap(beanFactory, executorService, stopWatch);
                this.preInstantiateSingletonsInParallel(dependentBeanNamesMap, beanFactory, executorService, stopWatch);
            }
            finally {
                executorService.shutdown();
            }
        }
        logger.info(stopWatch.toString());
    }

    private ExecutorService newExecutorService() {
        int threads = (Integer)this.environment.getProperty(THREADS_PROPERTY_NAME, Integer.TYPE, (Object)this.getDefaultThreads());
        if (threads < 1) {
            return null;
        }
        String threadNamePrefix = this.environment.getProperty(THREAD_NAME_PREFIX_PROPERTY_NAME, DEFAULT_THREAD_NAME_PREFIX);
        ExecutorService executorService = Executors.newFixedThreadPool(threads, (ThreadFactory)new CustomizableThreadFactory(threadNamePrefix));
        return executorService;
    }

    private Map<String, Set<String>> resolveDependentBeanNamesMap(DefaultListableBeanFactory beanFactory, ExecutorService executorService, StopWatch stopWatch) {
        stopWatch.start("resolveDependentBeanNamesMap");
        DefaultBeanDependencyResolver beanDependencyResolver = new DefaultBeanDependencyResolver((BeanFactory)beanFactory, executorService);
        Map<String, Set<String>> dependentBeanNamesMap = beanDependencyResolver.resolve((ConfigurableListableBeanFactory)beanFactory);
        stopWatch.stop();
        return dependentBeanNamesMap;
    }

    private void preInstantiateSingletonsInParallel(Map<String, Set<String>> dependentBeanNamesMap, DefaultListableBeanFactory beanFactory, ExecutorService executorService, StopWatch stopWatch) {
        stopWatch.start("preInstantiateSingletonsInParallel");
        List<Set<String>> beanNamesInDependencyPaths = this.resolveBeanNamesInDependencyPaths(dependentBeanNamesMap);
        for (int i = 0; i < beanNamesInDependencyPaths.size(); ++i) {
            Set<String> beanNamesInDependencyPath = beanNamesInDependencyPaths.get(i);
            executorService.submit(() -> {
                for (String beanName : beanNamesInDependencyPath) {
                    Object bean = beanFactory.getBean(beanName);
                    logger.debug("The bean[name : '{}'] was created : {}", (Object)beanName, bean);
                }
                return null;
            });
        }
        while (((Boolean)ThrowableSupplier.execute(() -> executorService.awaitTermination(10L, TimeUnit.MILLISECONDS))).booleanValue()) {
        }
        stopWatch.stop();
    }

    private List<Set<String>> resolveBeanNamesInDependencyPaths(Map<String, Set<String>> dependentBeanNamesMap) {
        Set<String> beanNames;
        int i;
        List<Set<String>> beanNamesList = this.buildBeanNamesList(dependentBeanNamesMap);
        LinkedList dependencyPaths = ListUtils.newLinkedList();
        int size = beanNamesList.size();
        for (i = 0; i < size; ++i) {
            beanNames = beanNamesList.get(i);
            if (beanNames.isEmpty()) continue;
            for (int j = i + 1; j < size; ++j) {
                Set<String> otherNames = beanNamesList.get(j);
                if (!CollectionUtils.containsAny(beanNames, otherNames)) continue;
                beanNames.addAll(otherNames);
                beanNamesList.set(j, Collections.emptySet());
            }
        }
        for (i = 0; i < size; ++i) {
            beanNames = beanNamesList.get(i);
            if (beanNames.isEmpty()) continue;
            dependencyPaths.add(beanNames);
        }
        return dependencyPaths;
    }

    private List<Set<String>> buildBeanNamesList(Map<String, Set<String>> dependentBeanNamesMap) {
        ArrayList beanNamesList = ListUtils.newArrayList((int)dependentBeanNamesMap.size());
        for (Map.Entry<String, Set<String>> dependentEntry : dependentBeanNamesMap.entrySet()) {
            Set<String> dependentBeanNames;
            String beanName = dependentEntry.getKey();
            Set<String> beanNames = dependentBeanNames = dependentEntry.getValue();
            beanNames.add(beanName);
            beanNamesList.add(beanNames);
        }
        return beanNamesList;
    }

    private void mergeBeanNames(Map.Entry<String, Set<String>> dependentEntry, List<Set<String>> allBeanNamesList, Map<String, Set<String>> dependentBeanNamesMap) {
        for (Map.Entry<String, Set<String>> entry : dependentBeanNamesMap.entrySet()) {
            if (dependentEntry.equals(entry)) continue;
            String beanName = dependentEntry.getKey();
            Set<String> dependentBeanNames = dependentEntry.getValue();
            LinkedHashSet<String> allBeanNames = new LinkedHashSet<String>(1 + dependentBeanNames.size());
            allBeanNames.add(beanName);
            allBeanNames.addAll(dependentBeanNames);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private int getDefaultThreads() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        return Math.max(1, availableProcessors);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = BeanFactoryUtils.asDefaultListableBeanFactory(beanFactory);
    }
}

