/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.core.annotation;

import io.microsphere.collection.MapUtils;
import io.microsphere.spring.core.annotation.GenericAnnotationAttributes;
import io.microsphere.spring.util.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class ResolvablePlaceholderAnnotationAttributes<A extends Annotation>
extends GenericAnnotationAttributes<A> {
    public ResolvablePlaceholderAnnotationAttributes(A annotation, @Nullable PropertyResolver propertyResolver) {
        this((Map<String, Object>)AnnotationUtils.getAnnotationAttributes(annotation, false, new String[0]), annotation.annotationType(), propertyResolver);
    }

    public ResolvablePlaceholderAnnotationAttributes(AnnotationAttributes another, @Nullable PropertyResolver propertyResolver) {
        this((Map<String, Object>)another, AnnotationUtils.findAnnotationType(another), propertyResolver);
    }

    public ResolvablePlaceholderAnnotationAttributes(Map<String, Object> another, Class<A> annotationType, @Nullable PropertyResolver propertyResolver) {
        super(ResolvablePlaceholderAnnotationAttributes.resolvePlaceholders(another, propertyResolver), annotationType);
    }

    private static Map<String, Object> resolvePlaceholders(Map<String, Object> source, @Nullable PropertyResolver propertyResolver) {
        if (source instanceof ResolvablePlaceholderAnnotationAttributes) {
            return source;
        }
        Map copy = MapUtils.shallowCloneMap(source);
        for (Map.Entry entry : copy.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                entry.setValue(ResolvablePlaceholderAnnotationAttributes.resolvePlaceholder((String)value, propertyResolver));
                continue;
            }
            if (!(value instanceof String[])) continue;
            entry.setValue(ResolvablePlaceholderAnnotationAttributes.resolvePlaceholders((String[])value, propertyResolver));
        }
        return copy;
    }

    private static String[] resolvePlaceholders(String[] values, @Nullable PropertyResolver propertyResolver) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = ResolvablePlaceholderAnnotationAttributes.resolvePlaceholder(values[i], propertyResolver);
        }
        return values;
    }

    private static String resolvePlaceholder(String value, @Nullable PropertyResolver propertyResolver) {
        return propertyResolver == null ? value : propertyResolver.resolvePlaceholders(value);
    }

    @NonNull
    public static <A extends Annotation> ResolvablePlaceholderAnnotationAttributes<A> of(@NonNull AnnotationAttributes attributes, @Nullable PropertyResolver propertyResolver) {
        if (attributes instanceof ResolvablePlaceholderAnnotationAttributes) {
            return (ResolvablePlaceholderAnnotationAttributes)attributes;
        }
        return new ResolvablePlaceholderAnnotationAttributes<A>(attributes, propertyResolver);
    }

    @NonNull
    public static <A extends Annotation> ResolvablePlaceholderAnnotationAttributes<A> of(@NonNull A annotation, @Nullable PropertyResolver propertyResolver) {
        return new ResolvablePlaceholderAnnotationAttributes<A>(annotation, propertyResolver);
    }

    @NonNull
    public static <A extends Annotation> ResolvablePlaceholderAnnotationAttributes<A> of(Map<String, Object> attributes, Class<A> annotationType, @Nullable PropertyResolver propertyResolver) {
        return new ResolvablePlaceholderAnnotationAttributes<A>(attributes, annotationType, propertyResolver);
    }

    @NonNull
    public static Set<AnnotationAttributes> ofSet(@Nullable AnnotationAttributes[] attributesArray, @Nullable PropertyResolver propertyResolver) {
        int length;
        int n = length = attributesArray == null ? 0 : attributesArray.length;
        if (length < 1) {
            return Collections.emptySet();
        }
        LinkedHashSet<AnnotationAttributes> annotationAttributesSet = new LinkedHashSet<AnnotationAttributes>();
        for (int i = 0; i < length; ++i) {
            AnnotationAttributes annotationAttributes = attributesArray[i];
            annotationAttributesSet.add(ResolvablePlaceholderAnnotationAttributes.of(annotationAttributes, propertyResolver));
        }
        return annotationAttributesSet;
    }
}

