/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.core.convert.support;

import io.microsphere.spring.util.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.format.support.DefaultFormattingConversionService;

public class ConversionServiceResolver {
    public static final String RESOLVED_CONVERSION_SERVICE_BEAN_NAME = "resolved-conversionService";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ConfigurableBeanFactory beanFactory;

    public ConversionServiceResolver(ConfigurableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ConversionService resolve() {
        return this.resolve(true);
    }

    public ConversionService resolve(boolean requireToRegister) {
        ConversionService conversionService = this.getResolvedBeanIfAvailable();
        if (conversionService == null) {
            conversionService = this.getFromBeanFactory();
        }
        if (conversionService == null) {
            this.debug("The conversionService instance can't be found in Spring ConfigurableBeanFactory.getConversionService()", new Object[0]);
            conversionService = this.getFromEnvironment();
        }
        if (conversionService == null) {
            this.debug("The conversionService instance can't be found in Spring ConfigurableEnvironment.getConversionService()", new Object[0]);
            conversionService = this.getIfAvailable();
        }
        if (conversionService == null) {
            conversionService = this.createDefaultConversionService();
        }
        if (!BeanUtils.isBeanPresent((BeanFactory)this.beanFactory, RESOLVED_CONVERSION_SERVICE_BEAN_NAME, ConversionService.class) && requireToRegister) {
            this.beanFactory.registerSingleton(RESOLVED_CONVERSION_SERVICE_BEAN_NAME, (Object)conversionService);
        }
        return conversionService;
    }

    private ConversionService getFromEnvironment() {
        if (this.beanFactory.containsBean("environment")) {
            ConfigurableEnvironment environment = (ConfigurableEnvironment)this.beanFactory.getBean("environment", ConfigurableEnvironment.class);
            return environment.getConversionService();
        }
        return null;
    }

    private ConversionService getResolvedBeanIfAvailable() {
        return BeanUtils.getBeanIfAvailable((BeanFactory)this.beanFactory, RESOLVED_CONVERSION_SERVICE_BEAN_NAME, ConversionService.class);
    }

    private ConversionService getFromBeanFactory() {
        return this.beanFactory.getConversionService();
    }

    private ConversionService getIfAvailable() {
        return BeanUtils.getBeanIfAvailable((BeanFactory)this.beanFactory, "conversionService", ConversionService.class);
    }

    protected ConversionService createDefaultConversionService() {
        return new DefaultFormattingConversionService();
    }

    private void debug(String message, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(args.length < 1 ? message : String.format(message, args)));
        }
    }
}

