/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.net;

import io.microsphere.net.SubProtocolURLConnectionFactory;
import io.microsphere.spring.util.BeanUtils;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.springframework.beans.factory.ListableBeanFactory;

public class SpringDelegatingBeanProtocolURLConnectionFactory
implements SubProtocolURLConnectionFactory {
    private final ListableBeanFactory beanFactory;

    public SpringDelegatingBeanProtocolURLConnectionFactory(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public boolean supports(URL url, List<String> subProtocols) {
        return this.selectDelegateIndex(url, subProtocols) > -1;
    }

    public URLConnection create(URL url, List<String> subProtocols, Proxy proxy) throws IOException {
        List<SubProtocolURLConnectionFactory> delegatingBeans = this.getDelegatingBeans();
        int index = this.selectDelegateIndex(url, subProtocols, delegatingBeans);
        SubProtocolURLConnectionFactory delegatingBean = delegatingBeans.get(index);
        return delegatingBean.create(url, subProtocols, proxy);
    }

    private int selectDelegateIndex(URL url, List<String> subProtocols) {
        List<SubProtocolURLConnectionFactory> delegatingBeans = this.getDelegatingBeans();
        return this.selectDelegateIndex(url, subProtocols, delegatingBeans);
    }

    private int selectDelegateIndex(URL url, List<String> subProtocols, List<SubProtocolURLConnectionFactory> factories) {
        int index = -1;
        int size = factories.size();
        for (int i = 0; i < size; ++i) {
            SubProtocolURLConnectionFactory factory = factories.get(i);
            if (!factory.supports(url, subProtocols)) continue;
            index = i;
            break;
        }
        return index;
    }

    private List<SubProtocolURLConnectionFactory> getDelegatingBeans() {
        return BeanUtils.getSortedBeans(this.beanFactory, SubProtocolURLConnectionFactory.class);
    }
}

