/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.net;

import io.microsphere.net.URLUtils;
import io.microsphere.spring.util.PropertySourcesUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.PropertySources;
import org.springframework.util.MimeType;

public class SpringPropertySourcesURLConnectionAdapter
extends URLConnection {
    public static final MimeType DEFAULT_MEDIA_TYPE = MimeType.valueOf((String)"text/properties");
    private final PropertySources propertySources;
    private final ConfigurableConversionService conversionService;

    protected SpringPropertySourcesURLConnectionAdapter(URL url, PropertySources propertySources, ConfigurableConversionService conversionService) {
        super(url);
        this.propertySources = propertySources;
        this.conversionService = conversionService;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URL url = this.getURL();
        String prefix = this.getPropertyNamePrefix(url);
        Map<String, Object> properties = PropertySourcesUtils.getSubProperties(this.propertySources, prefix);
        MimeType mediaType = this.getMediaType(url);
        String primaryType = mediaType.getType();
        String subtype = mediaType.getSubtype();
        Object result = this.convert(properties, Map.class, subtype);
        result = this.convert(result, subtype, primaryType);
        return this.convert(result, primaryType, InputStream.class);
    }

    @Override
    public void connect() throws IOException {
    }

    private Object convert(Object source, String sourceMediaType, String targetMediaType) throws UnsupportedOperationException {
        Class<?> sourceType = this.getJavaType(sourceMediaType);
        Class<?> targetType = this.getJavaType(targetMediaType);
        return this.convert(source, sourceType, targetType);
    }

    private Object convert(Object source, Class<?> sourceType, String targetMediaType) throws UnsupportedOperationException {
        Class<?> targetType = this.getJavaType(targetMediaType);
        return this.convert(source, sourceType, targetType);
    }

    private <T> T convert(Object source, String fromType, Class<T> targetType) throws UnsupportedOperationException {
        Class<?> sourceType = this.getJavaType(fromType);
        return this.convert(source, sourceType, targetType);
    }

    private <S, T> T convert(Object source, Class<S> sourceType, Class<T> targetType) throws UnsupportedOperationException {
        if (!this.conversionService.canConvert(sourceType, targetType)) {
            throw new UnsupportedOperationException("The source type['" + sourceType.getName() + "] can't be converted to the target type['" + targetType.getName() + "']!");
        }
        return (T)this.conversionService.convert(source, targetType);
    }

    private String getPropertyNamePrefix(URL url) {
        return URLUtils.resolveAuthority((String)url.getAuthority());
    }

    private MimeType getMediaType(URL url) {
        String path = URLUtils.resolvePath((URL)url);
        if (path.indexOf(47) == 0) {
            path = path.substring(1);
        }
        MimeType mimeType = path == null ? DEFAULT_MEDIA_TYPE : MimeType.valueOf((String)path);
        return mimeType;
    }

    private Class<?> getJavaType(String type) {
        if ("text".equals(type)) {
            return String.class;
        }
        if ("properties".equals(type)) {
            return Properties.class;
        }
        if ("map".equals(type)) {
            return Map.class;
        }
        throw new UnsupportedOperationException("The 'type'[" + type + "] does not be supported");
    }
}

