/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class SpringResourceURLConnectionAdapter
extends URLConnection {
    private final Resource resource;
    private final WritableResource writableResource;
    private MultiValueMap<String, String> requestProperties;
    private MultiValueMap<String, String> headers;

    protected SpringResourceURLConnectionAdapter(URL url, Resource resource) {
        super(url);
        this.resource = resource;
        this.writableResource = resource instanceof WritableResource ? (WritableResource)resource : null;
    }

    @Override
    public void setDoOutput(boolean dooutput) {
        if (this.writableResource == null && dooutput) {
            throw new UnsupportedOperationException("The resource does not support output!");
        }
        super.setDoOutput(dooutput);
    }

    @Override
    public String getHeaderField(String name) {
        MultiValueMap<String, String> headers = this.headers;
        return headers == null ? null : (String)headers.getFirst((Object)name);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        MultiValueMap<String, String> headers = this.headers;
        return headers == null ? Collections.emptyMap() : Collections.unmodifiableMap(headers);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        Map.Entry<String, List<String>> entry = this.getHeaderEntry(n);
        return entry == null ? null : entry.getKey();
    }

    @Override
    public String getHeaderField(int n) {
        Map.Entry<String, List<String>> entry = this.getHeaderEntry(n);
        if (entry == null) {
            return null;
        }
        List<String> value = entry.getValue();
        return value != null && value.isEmpty() ? value.get(0) : null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.writableResource == null) {
            throw new UnsupportedOperationException("The resource does not support output!");
        }
        return this.writableResource.getOutputStream();
    }

    @Override
    public void setRequestProperty(String key, String value) {
        MultiValueMap<String, String> requestProperties = this.doGetRequestProperties();
        requestProperties.put((Object)key, Arrays.asList(value));
    }

    @Override
    public void addRequestProperty(String key, String value) {
        MultiValueMap<String, String> requestProperties = this.doGetRequestProperties();
        requestProperties.add((Object)key, (Object)value);
    }

    @Override
    public String getRequestProperty(String key) {
        MultiValueMap<String, String> requestProperties = this.requestProperties;
        return requestProperties == null ? null : (String)requestProperties.getFirst((Object)key);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return Collections.unmodifiableMap(this.doGetRequestProperties());
    }

    @Override
    public void connect() throws IOException {
        this.connected = true;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + this.getURL();
    }

    protected Map.Entry<String, List<String>> getHeaderEntry(int n) {
        Set<Map.Entry<String, List<String>>> entries = this.getHeaderEntries();
        Iterator<Map.Entry<String, List<String>>> iterator = entries.iterator();
        Map.Entry<String, List<String>> entry = null;
        int i = 0;
        while (i < n & iterator.hasNext()) {
            entry = iterator.next();
            ++i;
        }
        return entry;
    }

    protected Set<Map.Entry<String, List<String>>> getHeaderEntries() {
        MultiValueMap<String, String> headers = this.headers;
        return headers == null ? Collections.emptySet() : headers.entrySet();
    }

    protected MultiValueMap<String, String> getHeaders() {
        LinkedMultiValueMap headers = this.headers;
        if (headers == null) {
            headers = new LinkedMultiValueMap();
        }
        return headers;
    }

    protected MultiValueMap<String, String> doGetRequestProperties() {
        LinkedMultiValueMap requestProperties = this.requestProperties;
        if (requestProperties == null) {
            this.requestProperties = requestProperties = new LinkedMultiValueMap();
        }
        return requestProperties;
    }
}

