/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.net;

import io.microsphere.net.URLUtils;
import io.microsphere.spring.net.SpringResourceURLConnection;
import io.microsphere.spring.net.SpringSubProtocolURLConnectionFactory;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SpringResourceURLConnectionFactory
extends SpringSubProtocolURLConnectionFactory {
    private static final String RESOURCE_SUB_PROTOCOL = "resource";
    private static final int RESOURCE_SCHEME_INDEX = 1;
    private final ResourceLoader resourceLoader;

    public SpringResourceURLConnectionFactory(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public URLConnection create(URL url, List<String> subProtocols, Proxy proxy) throws IOException {
        Resource resource = this.findResource(url, subProtocols);
        return new SpringResourceURLConnection(url, resource);
    }

    protected Resource findResource(URL url, List<String> subProtocols) throws IOException {
        ResourceLoader resourceLoader = this.resourceLoader;
        String location = this.buildLocation(url, subProtocols);
        Resource resource = resourceLoader.getResource(location);
        if (resource == null) {
            throw new IOException("The Spring resource can't be found from the URL : " + url);
        }
        return resource;
    }

    @Override
    protected String getSubProtocol() {
        return RESOURCE_SUB_PROTOCOL;
    }

    private String buildLocation(URL url, List<String> subProtocols) {
        String scheme = this.getResourceScheme(subProtocols);
        String authority = URLUtils.resolveAuthority((URL)url);
        String path = URLUtils.resolvePath((URL)url);
        return scheme + ':' + "/" + authority + path;
    }

    private String getResourceScheme(List<String> subProtocols) {
        return subProtocols.get(1);
    }
}

