/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.util;

import io.microsphere.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AnnotatedBeanDefinitionRegistryUtils {
    private static final Log logger = LogFactory.getLog(AnnotatedBeanDefinitionRegistryUtils.class);

    public static boolean isPresentBean(BeanDefinitionRegistry registry, Class<?> annotatedClass) {
        boolean present = false;
        String[] beanNames = registry.getBeanDefinitionNames();
        ClassLoader classLoader = annotatedClass.getClassLoader();
        for (String beanName : beanNames) {
            AnnotationMetadata annotationMetadata;
            String className;
            Class targetClass;
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (!(beanDefinition instanceof AnnotatedBeanDefinition) || !(present = ObjectUtils.nullSafeEquals((Object)(targetClass = ClassUtils.resolveClassName((String)(className = (annotationMetadata = ((AnnotatedBeanDefinition)beanDefinition).getMetadata()).getClassName()), (ClassLoader)classLoader)), annotatedClass))) continue;
            if (!logger.isDebugEnabled()) break;
            logger.debug((Object)String.format("The annotatedClass[class : %s , bean name : %s] was present in registry[%s]", className, beanName, registry));
            break;
        }
        return present;
    }

    public static void registerBeans(BeanDefinitionRegistry registry, Class<?> ... annotatedClasses) {
        if (ObjectUtils.isEmpty((Object[])annotatedClasses)) {
            return;
        }
        LinkedHashSet classesToRegister = new LinkedHashSet(Arrays.asList(annotatedClasses));
        Iterator iterator = classesToRegister.iterator();
        while (iterator.hasNext()) {
            Class annotatedClass = (Class)iterator.next();
            if (!AnnotatedBeanDefinitionRegistryUtils.isPresentBean(registry, annotatedClass)) continue;
            iterator.remove();
        }
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(registry);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(registry.getClass().getSimpleName() + " will register annotated classes : " + Arrays.asList(annotatedClasses) + " ."));
        }
        reader.register(classesToRegister.toArray(ArrayUtils.EMPTY_CLASS_ARRAY));
    }

    public static int scanBasePackages(BeanDefinitionRegistry registry, String ... basePackages) {
        int count = 0;
        if (!ObjectUtils.isEmpty((Object[])basePackages)) {
            boolean debugEnabled = logger.isDebugEnabled();
            if (debugEnabled) {
                logger.debug((Object)(registry.getClass().getSimpleName() + " will scan base packages " + Arrays.asList(basePackages) + "."));
            }
            List<String> registeredBeanNames = Arrays.asList(registry.getBeanDefinitionNames());
            ClassPathBeanDefinitionScanner classPathBeanDefinitionScanner = new ClassPathBeanDefinitionScanner(registry);
            count = classPathBeanDefinitionScanner.scan(basePackages);
            ArrayList<String> scannedBeanNames = new ArrayList<String>(count);
            scannedBeanNames.addAll(Arrays.asList(registry.getBeanDefinitionNames()));
            scannedBeanNames.removeAll(registeredBeanNames);
            if (debugEnabled) {
                logger.debug((Object)("The Scanned Components[ count : " + count + "] under base packages " + Arrays.asList(basePackages) + " : "));
            }
            for (String scannedBeanName : scannedBeanNames) {
                BeanDefinition scannedBeanDefinition = registry.getBeanDefinition(scannedBeanName);
                if (!debugEnabled) continue;
                logger.debug((Object)("Component [ name : " + scannedBeanName + " , class : " + scannedBeanDefinition.getBeanClassName() + " ]"));
            }
        }
        return count;
    }

    public static BeanNameGenerator resolveAnnotatedBeanNameGenerator(BeanDefinitionRegistry registry) {
        AnnotationBeanNameGenerator beanNameGenerator = null;
        if (registry instanceof SingletonBeanRegistry) {
            SingletonBeanRegistry singletonBeanRegistry = (SingletonBeanRegistry)SingletonBeanRegistry.class.cast(registry);
            beanNameGenerator = (BeanNameGenerator)singletonBeanRegistry.getSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator");
        }
        if (beanNameGenerator == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"BeanNameGenerator bean can't be found in BeanFactory with name [org.springframework.context.annotation.internalConfigurationBeanNameGenerator]");
                logger.info((Object)("BeanNameGenerator will be a instance of " + AnnotationBeanNameGenerator.class.getName() + " , it maybe a potential problem on bean name generation."));
            }
            beanNameGenerator = new AnnotationBeanNameGenerator();
        }
        return beanNameGenerator;
    }

    public static Set<BeanDefinitionHolder> findBeanDefinitionHolders(ClassPathBeanDefinitionScanner scanner, String packageToScan, BeanDefinitionRegistry registry, BeanNameGenerator beanNameGenerator) {
        Set beanDefinitions = scanner.findCandidateComponents(packageToScan);
        LinkedHashSet<BeanDefinitionHolder> beanDefinitionHolders = new LinkedHashSet<BeanDefinitionHolder>(beanDefinitions.size());
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String beanName = beanNameGenerator.generateBeanName(beanDefinition, registry);
            BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder(beanDefinition, beanName);
            beanDefinitionHolders.add(beanDefinitionHolder);
        }
        return beanDefinitionHolders;
    }
}

