/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.util;

import io.microsphere.spring.util.FieldUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.ClassUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class BeanFactoryUtils {
    public static <T> T getOptionalBean(ListableBeanFactory beanFactory, String beanName, Class<T> beanType) {
        if (!StringUtils.hasText((String)beanName)) {
            return null;
        }
        String[] beanNames = (String[])ArrayUtils.of((Object[])new String[]{beanName});
        List<T> beans = BeanFactoryUtils.getBeans(beanFactory, beanNames, beanType);
        return CollectionUtils.isEmpty(beans) ? null : (T)beans.get(0);
    }

    public static <T> List<T> getBeans(ListableBeanFactory beanFactory, String[] beanNames, Class<T> beanType) {
        if (ObjectUtils.isEmpty((Object[])beanNames)) {
            return Collections.emptyList();
        }
        Object[] allBeanNames = org.springframework.beans.factory.BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, beanType, (boolean)true, (boolean)false);
        ArrayList<Object> beans = new ArrayList<Object>(beanNames.length);
        for (String beanName : beanNames) {
            if (!ObjectUtils.containsElement((Object[])allBeanNames, (Object)beanName)) continue;
            beans.add(beanFactory.getBean(beanName, beanType));
        }
        return Collections.unmodifiableList(beans);
    }

    public static boolean isDefaultListableBeanFactory(Object beanFactory) {
        return beanFactory instanceof DefaultListableBeanFactory;
    }

    public static boolean isBeanDefinitionRegistry(Object beanFactory) {
        return beanFactory instanceof BeanDefinitionRegistry;
    }

    public static BeanDefinitionRegistry asBeanDefinitionRegistry(Object beanFactory) {
        return (BeanDefinitionRegistry)ClassUtils.cast((Object)beanFactory, BeanDefinitionRegistry.class);
    }

    public static ListableBeanFactory asListableBeanFactory(Object beanFactory) {
        return (ListableBeanFactory)ClassUtils.cast((Object)beanFactory, ListableBeanFactory.class);
    }

    public static HierarchicalBeanFactory asHierarchicalBeanFactory(Object beanFactory) {
        return (HierarchicalBeanFactory)ClassUtils.cast((Object)beanFactory, HierarchicalBeanFactory.class);
    }

    public static ConfigurableBeanFactory asConfigurableBeanFactory(Object beanFactory) {
        return (ConfigurableBeanFactory)ClassUtils.cast((Object)beanFactory, ConfigurableBeanFactory.class);
    }

    public static AutowireCapableBeanFactory asAutowireCapableBeanFactory(Object beanFactory) {
        return (AutowireCapableBeanFactory)ClassUtils.cast((Object)beanFactory, AutowireCapableBeanFactory.class);
    }

    public static ConfigurableListableBeanFactory asConfigurableListableBeanFactory(Object beanFactory) {
        return (ConfigurableListableBeanFactory)ClassUtils.cast((Object)beanFactory, ConfigurableListableBeanFactory.class);
    }

    public static DefaultListableBeanFactory asDefaultListableBeanFactory(Object beanFactory) {
        return (DefaultListableBeanFactory)ClassUtils.cast((Object)beanFactory, DefaultListableBeanFactory.class);
    }

    public static Set<Class<?>> getResolvableDependencyTypes(ConfigurableListableBeanFactory beanFactory) {
        DefaultListableBeanFactory defaultListableBeanFactory = BeanFactoryUtils.asDefaultListableBeanFactory(beanFactory);
        if (defaultListableBeanFactory == null) {
            return Collections.emptySet();
        }
        return BeanFactoryUtils.getResolvableDependencyTypes((DefaultListableBeanFactory)beanFactory);
    }

    public static Set<Class<?>> getResolvableDependencyTypes(DefaultListableBeanFactory beanFactory) {
        Map resolvableDependencies = FieldUtils.getFieldValue((Object)beanFactory, "resolvableDependencies", Map.class);
        return resolvableDependencies == null ? Collections.emptySet() : resolvableDependencies.keySet();
    }
}

