/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.util;

import io.microsphere.spring.beans.factory.DelegatingFactoryBean;
import io.microsphere.spring.util.BeanDefinitionUtils;
import java.beans.Introspector;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.AliasRegistry;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class BeanRegistrar {
    private static final Logger logger = LoggerFactory.getLogger(BeanRegistrar.class);

    public static boolean registerInfrastructureBean(BeanDefinitionRegistry registry, Class<?> beanType) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionUtils.genericBeanDefinition(beanType, 2);
        String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
        return BeanRegistrar.registerBeanDefinition(registry, beanName, (BeanDefinition)beanDefinition);
    }

    public static boolean registerInfrastructureBean(BeanDefinitionRegistry registry, String beanName, Class<?> beanType) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionUtils.genericBeanDefinition(beanType, 2);
        return BeanRegistrar.registerBeanDefinition(registry, beanName, (BeanDefinition)beanDefinition);
    }

    public static boolean registerBeanDefinition(BeanDefinitionRegistry registry, Class<?> beanType) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionUtils.genericBeanDefinition(beanType);
        String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
        return BeanRegistrar.registerBeanDefinition(registry, beanName, (BeanDefinition)beanDefinition);
    }

    public static boolean registerBeanDefinition(BeanDefinitionRegistry registry, String beanName, Class<?> beanType) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionUtils.genericBeanDefinition(beanType);
        return BeanRegistrar.registerBeanDefinition(registry, beanName, (BeanDefinition)beanDefinition);
    }

    public static boolean registerBeanDefinition(BeanDefinitionRegistry registry, String beanName, Class<?> beanType, Object ... constructorArguments) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionUtils.genericBeanDefinition(beanType, constructorArguments);
        return BeanRegistrar.registerBeanDefinition(registry, beanName, (BeanDefinition)beanDefinition);
    }

    public static boolean registerBeanDefinition(BeanDefinitionRegistry registry, String beanName, Class<?> beanType, int role) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionUtils.genericBeanDefinition(beanType, role);
        return BeanRegistrar.registerBeanDefinition(registry, beanName, (BeanDefinition)beanDefinition);
    }

    public static final boolean registerBeanDefinition(BeanDefinitionRegistry registry, String beanName, BeanDefinition beanDefinition) {
        return BeanRegistrar.registerBeanDefinition(registry, beanName, beanDefinition, false);
    }

    public static final boolean registerBeanDefinition(BeanDefinitionRegistry registry, String beanName, BeanDefinition beanDefinition, boolean allowBeanDefinitionOverriding) {
        boolean registered = false;
        if (!allowBeanDefinitionOverriding && registry.containsBeanDefinition(beanName)) {
            BeanDefinition oldBeanDefinition = registry.getBeanDefinition(beanName);
            if (logger.isWarnEnabled()) {
                logger.warn("The bean[name : '{}'] definition [{}] was registered!", (Object)beanName, (Object)oldBeanDefinition);
            }
        } else {
            try {
                registry.registerBeanDefinition(beanName, beanDefinition);
                if (logger.isDebugEnabled()) {
                    logger.debug("The bean[name : '{}' , role : {}] definition [{}] has been registered.", new Object[]{beanName, beanDefinition.getRole(), beanDefinition});
                }
                registered = true;
            }
            catch (BeanDefinitionStoreException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("The bean[name : '{}' , role : {}] definition [{}] can't be registered ", new Object[]{beanName, beanDefinition.getRole(), e});
                }
                registered = false;
            }
        }
        return registered;
    }

    public static void registerSingleton(SingletonBeanRegistry registry, String beanName, Object bean) {
        registry.registerSingleton(beanName, bean);
        if (logger.isInfoEnabled()) {
            logger.info("The singleton bean [name : '{}' , instance : {}] has been registered into the BeanFactory.", (Object)beanName, bean);
        }
    }

    public static boolean hasAlias(AliasRegistry registry, String beanName, String alias) {
        return StringUtils.hasText((String)beanName) && StringUtils.hasText((String)alias) && ObjectUtils.containsElement((Object[])registry.getAliases(beanName), (Object)alias);
    }

    public static int registerSpringFactoriesBeans(BeanDefinitionRegistry registry, Class<?> ... factoryClasses) {
        int count = 0;
        ClassLoader classLoader = registry.getClass().getClassLoader();
        for (int i = 0; i < factoryClasses.length; ++i) {
            Class<?> factoryClass = factoryClasses[i];
            List factoryImplClassNames = SpringFactoriesLoader.loadFactoryNames(factoryClass, (ClassLoader)classLoader);
            for (String factoryImplClassName : factoryImplClassNames) {
                Class factoryImplClass = ClassUtils.resolveClassName((String)factoryImplClassName, (ClassLoader)classLoader);
                String beanName = Introspector.decapitalize(ClassUtils.getShortName((String)factoryImplClassName));
                if (BeanRegistrar.registerInfrastructureBean(registry, beanName, factoryImplClass)) {
                    ++count;
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn(String.format("The Factory Class bean[%s] has been registered with bean name[%s]", factoryImplClassName, beanName));
            }
        }
        return count;
    }

    public static final void registerFactoryBean(BeanDefinitionRegistry registry, String beanName, Object bean) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionUtils.genericBeanDefinition(DelegatingFactoryBean.class, bean);
        beanDefinition.setSource(bean);
        BeanRegistrar.registerBeanDefinition(registry, beanName, (BeanDefinition)beanDefinition);
    }

    public static void registerBean(BeanDefinitionRegistry registry, String beanName, Object bean) {
        BeanRegistrar.registerBean(registry, beanName, bean, false);
    }

    public static void registerBean(BeanDefinitionRegistry registry, String beanName, Object bean, boolean primary) {
        Class beanClass = AopUtils.getTargetClass((Object)bean);
        AbstractBeanDefinition beanDefinition = BeanDefinitionUtils.genericBeanDefinition(beanClass);
        beanDefinition.setInstanceSupplier(() -> bean);
        beanDefinition.setPrimary(primary);
        BeanRegistrar.registerBeanDefinition(registry, beanName, (BeanDefinition)beanDefinition);
    }
}

