/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public abstract class EnvironmentUtils {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentUtils.class);

    private EnvironmentUtils() throws InstantiationException {
        throw new InstantiationException();
    }

    public static Map<String, String> getProperties(Environment environment, String ... propertyNames) {
        int length;
        int n = length = propertyNames == null ? 0 : propertyNames.length;
        if (length < 1) {
            return Collections.emptyMap();
        }
        if (length == 1) {
            String propertyName = propertyNames[0];
            return StringUtils.hasText((String)propertyName) ? Collections.singletonMap(propertyName, environment.getProperty(propertyName)) : Collections.emptyMap();
        }
        return EnvironmentUtils.getProperties(environment, Arrays.asList(propertyNames));
    }

    public static Map<String, String> getProperties(Environment environment, Iterable<String> propertyNames) {
        Set propertyNamesSet = propertyNames instanceof Set ? (Set)propertyNames : (propertyNames instanceof Collection ? new HashSet((Collection)propertyNames) : StreamSupport.stream(propertyNames.spliterator(), false).collect(Collectors.toSet()));
        return EnvironmentUtils.getProperties(environment, propertyNamesSet);
    }

    public static Map<String, String> getProperties(Environment environment, Set<String> propertyNames) {
        HashMap properties = new HashMap(propertyNames.size());
        propertyNames.stream().filter(StringUtils::hasText).forEach(name -> properties.put(name, environment.getProperty(name)));
        return Collections.unmodifiableMap(properties);
    }

    public static ConversionService getConversionService(Environment environment) {
        ConfigurableConversionService conversionService = null;
        if (environment instanceof ConfigurablePropertyResolver && (conversionService = ((ConfigurablePropertyResolver)environment).getConversionService()) == null) {
            conversionService = DefaultConversionService.getSharedInstance();
            logger.warn("ConversionService can't be resolved from Environment[class: {}], the shared ApplicationConversionService will be used!", (Object)environment.getClass().getName());
        }
        return conversionService;
    }

    public static List<String> resolveCommaDelimitedValueToList(Environment environment, String commaDelimitedValue) {
        List values = EnvironmentUtils.resolvePlaceholders(environment, commaDelimitedValue, List.class);
        return values == null ? Collections.emptyList() : Collections.unmodifiableList(values);
    }

    public static <T> T resolvePlaceholders(Environment environment, String propertyValue, Class<T> targetType) {
        return EnvironmentUtils.resolvePlaceholders(environment, propertyValue, targetType, null);
    }

    public static <T> T resolvePlaceholders(Environment environment, String propertyValue, Class<T> targetType, T defaultValue) {
        Object targetValue;
        if (propertyValue == null) {
            return defaultValue;
        }
        ConversionService conversionService = EnvironmentUtils.getConversionService(environment);
        if (conversionService == null) {
            return defaultValue;
        }
        String resolvedPropertyValue = environment.resolvePlaceholders(propertyValue);
        if (conversionService.canConvert(String.class, targetType)) {
            targetValue = conversionService.convert((Object)resolvedPropertyValue, targetType);
            logger.debug("The property value[origin : {} , resolved : {}] was converted to be {}(type :{})!", new Object[]{propertyValue, resolvedPropertyValue, targetValue, targetType});
        } else {
            targetValue = defaultValue;
            logger.debug("The property value[origin : {} , resolved : {}] can't be converted to be the target type[{}], take the default value({}) as result!", new Object[]{propertyValue, resolvedPropertyValue, targetValue, targetType});
        }
        return targetValue;
    }
}

