/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.util;

import java.lang.reflect.Field;
import org.springframework.util.ReflectionUtils;

public abstract class FieldUtils {
    public static <T> T getFieldValue(Object object, String fieldName) {
        return FieldUtils.getFieldValue(object, fieldName, null);
    }

    public static <T> T getFieldValue(Object object, String fieldName, T defaultValue) {
        T value = FieldUtils.getFieldValue(object, fieldName);
        return value != null ? value : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getFieldValue(Object object, String fieldName, Class<T> fieldType) {
        Object fieldValue = null;
        Field field = ReflectionUtils.findField(object.getClass(), (String)fieldName, fieldType);
        if (field != null) {
            boolean accessible = field.isAccessible();
            try {
                if (!accessible) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                fieldValue = ReflectionUtils.getField((Field)field, (Object)object);
            }
            finally {
                if (!accessible) {
                    field.setAccessible(accessible);
                }
            }
        }
        return (T)fieldValue;
    }
}

