/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.util;

import io.microsphere.util.BaseUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.ShutdownHookUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class ResourceLoaderUtils
extends BaseUtils {
    private static ConcurrentMap<ClassLoader, ResourceLoader> resourceLoadersCache = new ConcurrentHashMap<ClassLoader, ResourceLoader>();

    @NonNull
    public static ResourceLoader getResourceLoader() {
        return ResourceLoaderUtils.getResourceLoader(ClassLoaderUtils.getDefaultClassLoader());
    }

    @NonNull
    public static ResourceLoader getResourceLoader(@Nullable ClassLoader classLoader) {
        ClassLoader targetClassLoader = classLoader == null ? ClassLoaderUtils.getDefaultClassLoader() : classLoader;
        return resourceLoadersCache.computeIfAbsent(targetClassLoader, DefaultResourceLoader::new);
    }

    @NonNull
    public static ResourcePatternResolver getResourcePatternResolver() {
        return ResourceLoaderUtils.getResourcePatternResolver(null);
    }

    @NonNull
    public static ResourcePatternResolver getResourcePatternResolver(@Nullable ResourceLoader resourceLoader) {
        ClassLoader classLoader = ResourceLoaderUtils.getClassLoader(resourceLoader);
        return (ResourcePatternResolver)resourceLoadersCache.computeIfAbsent(classLoader, cl -> {
            Object resourcePatternResolver = null;
            resourcePatternResolver = resourceLoader instanceof ResourcePatternResolver ? (ResourcePatternResolver)resourceLoader : new PathMatchingResourcePatternResolver(cl);
            return resourcePatternResolver;
        });
    }

    protected static ClassLoader getClassLoader(@Nullable ResourceLoader resourceLoader) {
        ClassLoader classLoader = resourceLoader == null ? null : resourceLoader.getClassLoader();
        return classLoader == null ? ClassLoaderUtils.getDefaultClassLoader() : classLoader;
    }

    static {
        ShutdownHookUtils.addShutdownHookCallback(resourceLoadersCache::clear);
    }
}

