/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.util;

import io.microsphere.text.FormatUtils;
import io.microsphere.util.BaseUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.Version;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class SpringVersionUtils
extends BaseUtils {
    private static final ClassLoader classLoader = ClassLoaderUtils.getDefaultClassLoader();
    public static final String SPRING_BASE_PACKAGE_NAME = "org.springframework";
    @NonNull
    public static final Version SPRING_CORE_VERSION = SpringVersionUtils.getSpringVersion(StringUtils.class);
    @Nullable
    public static final Version SPRING_AOP_VERSION = SpringVersionUtils.getSpringVersion("org.springframework.aop.Advisor");
    @NonNull
    public static final Version SPRING_BEANS_VERSION = SpringVersionUtils.getSpringVersion(BeanFactory.class);
    @NonNull
    public static final Version SPRING_CONTEXT_VERSION = SpringVersionUtils.getSpringVersion(ApplicationContext.class);
    @Nullable
    public static final Version SPRING_CONTEXT_SUPPORT_VERSION = SpringVersionUtils.getSpringVersion("org.springframework.mail.MailSender");

    @Nullable
    public static Version getSpringVersion(String springClassName) throws NullPointerException, IllegalArgumentException {
        Class springClass = ClassLoaderUtils.resolveClass((String)springClassName, (ClassLoader)classLoader);
        return springClass == null ? null : SpringVersionUtils.getSpringVersion(springClass);
    }

    @NonNull
    public static Version getSpringVersion(Class<?> springClass) throws NullPointerException, IllegalArgumentException {
        Package classPackage = springClass.getPackage();
        String classPackageName = classPackage.getName();
        if (!classPackageName.startsWith(SPRING_BASE_PACKAGE_NAME)) {
            String errorMessage = FormatUtils.format((String)"The class[name : '{}'] is not packaged into the Spring package['{}']", (Object[])new Object[]{springClass.getName(), SPRING_BASE_PACKAGE_NAME});
            throw new IllegalArgumentException(errorMessage);
        }
        String implementationVersion = classPackage.getImplementationVersion();
        if (implementationVersion == null) {
            // empty if block
        }
        return implementationVersion == null ? null : Version.of((String)implementationVersion);
    }
}

