/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.context.ApplicationContextUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.BaseUtils;
import io.microsphere.util.ClassLoaderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class BeanUtils
extends BaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtils.class);

    public static boolean isBeanPresent(ListableBeanFactory beanFactory, Class<?> beanClass) {
        return BeanUtils.isBeanPresent(beanFactory, beanClass, false);
    }

    public static boolean isBeanPresent(ListableBeanFactory beanFactory, Class<?> beanClass, boolean includingAncestors) {
        Object[] beanNames = BeanUtils.getBeanNames(beanFactory, beanClass, includingAncestors);
        return !ArrayUtils.isEmpty((Object[])beanNames);
    }

    public static boolean isBeanPresent(ListableBeanFactory beanFactory, String beanClassName) {
        return BeanUtils.isBeanPresent(beanFactory, beanClassName, false);
    }

    public static boolean isBeanPresent(ListableBeanFactory beanFactory, String beanClassName, boolean includingAncestors) {
        Class beanClass;
        ClassLoader classLoader = null;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
            classLoader = configurableBeanFactory.getBeanClassLoader();
        }
        if ((beanClass = ClassLoaderUtils.resolveClass((String)beanClassName, classLoader)) == null) {
            return false;
        }
        return BeanUtils.isBeanPresent(beanFactory, beanClass, includingAncestors);
    }

    public static boolean isBeanPresent(BeanFactory beanFactory, String beanName, Class<?> beanClass) throws NullPointerException {
        return beanFactory.containsBean(beanName) && beanFactory.isTypeMatch(beanName, beanClass);
    }

    public static String[] getBeanNames(ListableBeanFactory beanFactory, Class<?> beanClass) {
        return BeanUtils.getBeanNames(beanFactory, beanClass, false);
    }

    public static String[] getBeanNames(ListableBeanFactory beanFactory, Class<?> beanClass, boolean includingAncestors) {
        if (includingAncestors) {
            return org.springframework.beans.factory.BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, beanClass, (boolean)true, (boolean)false);
        }
        return beanFactory.getBeanNamesForType(beanClass, true, false);
    }

    public static String[] getBeanNames(ConfigurableListableBeanFactory beanFactory, Class<?> beanClass) {
        return BeanUtils.getBeanNames(beanFactory, beanClass, false);
    }

    public static String[] getBeanNames(ConfigurableListableBeanFactory beanFactory, Class<?> beanClass, boolean includingAncestors) {
        return BeanUtils.getBeanNames((ListableBeanFactory)beanFactory, beanClass, includingAncestors);
    }

    public static Class<?> resolveBeanType(String beanClassName, ClassLoader classLoader) {
        Class beanType;
        block3: {
            if (!StringUtils.hasText((String)beanClassName)) {
                return null;
            }
            beanType = null;
            try {
                beanType = ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)classLoader);
                beanType = ClassUtils.getUserClass((Class)beanType);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return beanType;
    }

    public static <T> T getOptionalBean(ListableBeanFactory beanFactory, Class<T> beanClass, boolean includingAncestors) throws BeansException {
        Object bean;
        block4: {
            Object[] beanNames = BeanUtils.getBeanNames(beanFactory, beanClass, includingAncestors);
            if (ArrayUtils.isEmpty((Object[])beanNames)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("The bean [ class : " + beanClass.getName() + " ] can't be found ");
                }
                return null;
            }
            bean = null;
            try {
                bean = includingAncestors ? org.springframework.beans.factory.BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, beanClass) : beanFactory.getBean(beanClass);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return (T)bean;
    }

    public static <T> T getOptionalBean(ListableBeanFactory beanFactory, Class<T> beanClass) throws BeansException {
        return BeanUtils.getOptionalBean(beanFactory, beanClass, false);
    }

    public static <T> T getBeanIfAvailable(BeanFactory beanFactory, String beanName, Class<T> beanType) throws BeansException {
        if (BeanUtils.isBeanPresent(beanFactory, beanName, beanType)) {
            return (T)beanFactory.getBean(beanName, beanType);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("The bean[name : '{}' , type : {}] can't be found in Spring BeanFactory", new Object[]{beanName, beanType.getName()});
        }
        return null;
    }

    public static <T> List<T> getSortedBeans(BeanFactory beanFactory, Class<T> type) {
        if (beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            return BeanUtils.getSortedBeans(lbf, type);
        }
        return Collections.emptyList();
    }

    public static <T> List<T> getSortedBeans(ListableBeanFactory beanFactory, Class<T> type) {
        Map beansOfType = org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, type);
        ArrayList beansList = new ArrayList(beansOfType.values());
        AnnotationAwareOrderComparator.sort(beansList);
        return Collections.unmodifiableList(beansList);
    }

    public static void invokeBeanInterfaces(Object bean, ApplicationContext context) {
        ConfigurableApplicationContext configurableApplicationContext = ApplicationContextUtils.asConfigurableApplicationContext(context);
        BeanUtils.invokeBeanInterfaces(bean, configurableApplicationContext);
    }

    public static void invokeBeanInterfaces(Object bean, ConfigurableApplicationContext context) {
        BeanUtils.invokeAwareInterfaces(bean, context);
        try {
            BeanUtils.invokeInitializingBean(bean);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void invokeInitializingBean(Object bean) throws Exception {
        if (bean instanceof InitializingBean) {
            InitializingBean initializingBean = (InitializingBean)bean;
            initializingBean.afterPropertiesSet();
        }
    }

    public static void invokeAwareInterfaces(Object bean, BeanFactory beanFactory) {
        BeanUtils.invokeAwareInterfaces(bean, beanFactory, BeanFactoryUtils.asConfigurableBeanFactory(beanFactory));
    }

    public static void invokeAwareInterfaces(Object bean, ConfigurableBeanFactory beanFactory) {
        BeanUtils.invokeAwareInterfaces(bean, (BeanFactory)beanFactory, beanFactory);
    }

    public static void invokeAwareInterfaces(Object bean, BeanFactory beanFactory, @Nullable ConfigurableBeanFactory configurableBeanFactory) {
        if (beanFactory instanceof ApplicationContext) {
            ApplicationContext context = (ApplicationContext)beanFactory;
            BeanUtils.invokeAwareInterfaces(bean, context);
        } else {
            BeanUtils.invokeBeanFactoryAwareInterfaces(bean, beanFactory, configurableBeanFactory);
        }
    }

    static void invokeBeanFactoryAwareInterfaces(Object bean, BeanFactory beanFactory, @Nullable ConfigurableBeanFactory configurableBeanFactory) {
        BeanUtils.invokeBeanNameAware(bean, beanFactory);
        BeanUtils.invokeBeanClassLoaderAware(bean, configurableBeanFactory);
        BeanUtils.invokeBeanFactoryAware(bean, beanFactory);
    }

    static void invokeBeanNameAware(Object bean, BeanFactory beanFactory) {
        if (bean instanceof BeanNameAware) {
            BeanNameAware beanNameAware = (BeanNameAware)bean;
            BeanDefinitionRegistry registry = BeanFactoryUtils.asBeanDefinitionRegistry(beanFactory);
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(bean.getClass()).getBeanDefinition();
            String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
            beanNameAware.setBeanName(beanName);
        }
    }

    public static void invokeBeanNameAware(Object bean, String beanName) {
        if (bean instanceof BeanNameAware) {
            BeanNameAware beanNameAware = (BeanNameAware)bean;
            beanNameAware.setBeanName(beanName);
        }
    }

    static void invokeBeanFactoryAware(Object bean, BeanFactory beanFactory) {
        if (bean instanceof BeanFactoryAware) {
            BeanFactoryAware beanFactoryAware = (BeanFactoryAware)bean;
            beanFactoryAware.setBeanFactory(beanFactory);
        }
    }

    static void invokeBeanClassLoaderAware(Object bean, @Nullable ConfigurableBeanFactory configurableBeanFactory) {
        if (bean instanceof BeanClassLoaderAware) {
            BeanClassLoaderAware beanClassLoaderAware = (BeanClassLoaderAware)bean;
            if (configurableBeanFactory != null) {
                ClassLoader classLoader = configurableBeanFactory.getBeanClassLoader();
                beanClassLoaderAware.setBeanClassLoader(classLoader);
            }
        }
    }

    static void invokeAwareInterfaces(Object bean, ApplicationContext context) {
        BeanUtils.invokeAwareInterfaces(bean, context, ApplicationContextUtils.asConfigurableApplicationContext(context));
    }

    public static void invokeAwareInterfaces(Object bean, ConfigurableApplicationContext context) {
        BeanUtils.invokeAwareInterfaces(bean, (ApplicationContext)context, context);
    }

    static void invokeAwareInterfaces(Object bean, ApplicationContext context, @Nullable ConfigurableApplicationContext applicationContext) {
        if (bean == null || context == null) {
            return;
        }
        ConfigurableListableBeanFactory beanFactory = applicationContext != null ? applicationContext.getBeanFactory() : null;
        BeanUtils.invokeBeanFactoryAwareInterfaces(bean, (BeanFactory)beanFactory, (ConfigurableBeanFactory)beanFactory);
        BeanPostProcessor beanPostProcessor = ApplicationContextUtils.getApplicationContextAwareProcessor((BeanFactory)beanFactory);
        if (beanPostProcessor != null) {
            beanPostProcessor.postProcessBeforeInitialization(bean, "");
        }
    }

    static <T> Map<String, T> sort(Map<String, T> beansMap) {
        Map<String, T> unmodifiableBeansMap = Collections.unmodifiableMap(beansMap);
        ArrayList<NamingBean<T>> namingBeans = new ArrayList<NamingBean<T>>(unmodifiableBeansMap.size());
        for (Map.Entry<String, T> entry : unmodifiableBeansMap.entrySet()) {
            String string = entry.getKey();
            T bean = entry.getValue();
            NamingBean<T> namingBean = new NamingBean<T>(string, bean);
            namingBeans.add(namingBean);
        }
        AnnotationAwareOrderComparator.sort(namingBeans);
        LinkedHashMap sortedBeansMap = new LinkedHashMap(beansMap.size());
        for (NamingBean namingBean : namingBeans) {
            sortedBeansMap.put(namingBean.name, namingBean.bean);
        }
        return sortedBeansMap;
    }

    static class NamingBean<T>
    extends AnnotationAwareOrderComparator
    implements Comparable<NamingBean>,
    Ordered {
        private final String name;
        private final T bean;

        NamingBean(String name, T bean) {
            this.name = name;
            this.bean = bean;
        }

        @Override
        public int compareTo(NamingBean o) {
            return this.compare(this, o);
        }

        public int getOrder() {
            return this.getOrder(this.bean);
        }
    }
}

