/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.TypeUtils;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.beans.factory.InjectionPointDependencyResolver;
import io.microsphere.spring.beans.factory.filter.ResolvableDependencyTypeFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.MethodParameter;

public abstract class AbstractInjectionPointDependencyResolver
implements InjectionPointDependencyResolver,
BeanFactoryAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ResolvableDependencyTypeFilter resolvableDependencyTypeFilter;

    @Override
    public void resolve(Field field, ConfigurableListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        String dependentBeanName = this.resolveDependentBeanNameByName(field, beanFactory);
        if (dependentBeanName == null) {
            this.resolveDependentBeanNamesByType(field::getGenericType, beanFactory, dependentBeanNames);
        } else {
            dependentBeanNames.add(dependentBeanName);
        }
    }

    @Override
    public void resolve(Method method, ConfigurableListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        int parametersCount = method.getParameterCount();
        if (parametersCount < 1) {
            this.logger.trace("The no-argument method[{}] will be ignored", new Object[]{method});
            return;
        }
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parametersCount; ++i) {
            Parameter parameter = parameters[i];
            this.resolve(parameter, beanFactory, dependentBeanNames);
        }
    }

    @Override
    public void resolve(Constructor constructor, ConfigurableListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        int parametersCount = constructor.getParameterCount();
        if (parametersCount < 1) {
            this.logger.trace("The no-argument constructor[{}] will be ignored", new Object[]{constructor});
            return;
        }
        Parameter[] parameters = constructor.getParameters();
        for (int i = 0; i < parametersCount; ++i) {
            Parameter parameter = parameters[i];
            this.resolve(parameter, beanFactory, dependentBeanNames);
        }
    }

    @Override
    public void resolve(Parameter parameter, ConfigurableListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        String dependentBeanName = this.resolveDependentBeanNameByName(parameter, beanFactory);
        if (dependentBeanName == null) {
            this.resolveDependentBeanNamesByType(parameter::getParameterizedType, beanFactory, dependentBeanNames);
        } else {
            dependentBeanNames.add(dependentBeanName);
        }
    }

    protected String resolveDependentBeanNameByName(Field field, ConfigurableListableBeanFactory beanFactory) {
        AutowireCandidateResolver autowireCandidateResolver = this.getAutowireCandidateResolver(beanFactory);
        if (autowireCandidateResolver == null) {
            return null;
        }
        DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(field, true, false);
        return this.resolveDependentBeanNameByName(dependencyDescriptor, autowireCandidateResolver);
    }

    protected String resolveDependentBeanNameByName(Parameter parameter, ConfigurableListableBeanFactory beanFactory) {
        AutowireCandidateResolver autowireCandidateResolver = this.getAutowireCandidateResolver(beanFactory);
        if (autowireCandidateResolver == null) {
            return null;
        }
        DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(MethodParameter.forParameter((Parameter)parameter), true, false);
        return this.resolveDependentBeanNameByName(dependencyDescriptor, autowireCandidateResolver);
    }

    protected String resolveDependentBeanNameByName(DependencyDescriptor dependencyDescriptor, AutowireCandidateResolver autowireCandidateResolver) {
        String value;
        if (autowireCandidateResolver == null) {
            return null;
        }
        Object suggestedValue = autowireCandidateResolver.getSuggestedValue(dependencyDescriptor);
        return suggestedValue instanceof String ? (value = (String)suggestedValue) : null;
    }

    protected void resolveDependentBeanNamesByType(Supplier<Type> typeSupplier, ConfigurableListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        Class<?> dependentType = this.resolveDependentType(typeSupplier);
        if (this.resolvableDependencyTypeFilter.accept(dependentType)) {
            return;
        }
        String[] beanNames = beanFactory.getBeanNamesForType(dependentType, false, false);
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            dependentBeanNames.add(beanName);
        }
    }

    protected AutowireCandidateResolver getAutowireCandidateResolver(ConfigurableListableBeanFactory beanFactory) {
        DefaultListableBeanFactory dbf = BeanFactoryUtils.asDefaultListableBeanFactory(beanFactory);
        return dbf == null ? null : dbf.getAutowireCandidateResolver();
    }

    private Class<?> resolveDependentType(Supplier<Type> typeSupplier) {
        Type type = typeSupplier.get();
        return this.resolveDependentType(type);
    }

    protected Class<?> resolveDependentType(Type type) {
        List arguments;
        int argumentsSize;
        Class<?> klass;
        Class<?> dependentType = klass = TypeUtils.asClass((Type)type);
        if (TypeUtils.isParameterizedType((Object)type) && (argumentsSize = (arguments = TypeUtils.resolveActualTypeArguments((Type)type, (Class)klass)).size()) > 0) {
            Type argumentType = (Type)arguments.get(argumentsSize - 1);
            Class argumentClass = TypeUtils.asClass((Type)argumentType);
            if (argumentClass == null) {
                dependentType = this.resolveDependentType(argumentType);
            } else {
                if (argumentClass.isArray()) {
                    return argumentClass.getComponentType();
                }
                return argumentClass;
            }
        }
        return dependentType;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.resolvableDependencyTypeFilter = ResolvableDependencyTypeFilter.getSingleton(beanFactory);
    }
}

