/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory;

import io.microsphere.reflect.FieldUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.BaseUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class BeanFactoryUtils
extends BaseUtils {
    public static <T> T getOptionalBean(ListableBeanFactory beanFactory, String beanName, Class<T> beanType) {
        if (!StringUtils.hasText((String)beanName)) {
            return null;
        }
        String[] beanNames = (String[])ArrayUtils.of((Object[])new String[]{beanName});
        List<T> beans = BeanFactoryUtils.getBeans(beanFactory, beanNames, beanType);
        return CollectionUtils.isEmpty(beans) ? null : (T)beans.get(0);
    }

    public static <T> List<T> getBeans(ListableBeanFactory beanFactory, String[] beanNames, Class<T> beanType) {
        int size = ArrayUtils.size((Object[])beanNames);
        if (size < 1) {
            return Collections.emptyList();
        }
        Object[] allBeanNames = org.springframework.beans.factory.BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, beanType, (boolean)true, (boolean)false);
        ArrayList<Object> beans = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            String beanName = beanNames[i];
            if (!ObjectUtils.containsElement((Object[])allBeanNames, (Object)beanName)) continue;
            beans.add(beanFactory.getBean(beanName, beanType));
        }
        return Collections.unmodifiableList(beans);
    }

    public static boolean isDefaultListableBeanFactory(Object beanFactory) {
        return beanFactory instanceof DefaultListableBeanFactory;
    }

    public static boolean isBeanDefinitionRegistry(Object beanFactory) {
        return beanFactory instanceof BeanDefinitionRegistry;
    }

    public static BeanDefinitionRegistry asBeanDefinitionRegistry(Object beanFactory) {
        return BeanFactoryUtils.cast(beanFactory, BeanDefinitionRegistry.class);
    }

    public static ListableBeanFactory asListableBeanFactory(Object beanFactory) {
        return BeanFactoryUtils.cast(beanFactory, ListableBeanFactory.class);
    }

    public static HierarchicalBeanFactory asHierarchicalBeanFactory(Object beanFactory) {
        return BeanFactoryUtils.cast(beanFactory, HierarchicalBeanFactory.class);
    }

    public static ConfigurableBeanFactory asConfigurableBeanFactory(Object beanFactory) {
        return BeanFactoryUtils.cast(beanFactory, ConfigurableBeanFactory.class);
    }

    public static AutowireCapableBeanFactory asAutowireCapableBeanFactory(Object beanFactory) {
        return BeanFactoryUtils.cast(beanFactory, AutowireCapableBeanFactory.class);
    }

    public static ConfigurableListableBeanFactory asConfigurableListableBeanFactory(Object beanFactory) {
        return BeanFactoryUtils.cast(beanFactory, ConfigurableListableBeanFactory.class);
    }

    public static DefaultListableBeanFactory asDefaultListableBeanFactory(Object beanFactory) {
        return BeanFactoryUtils.cast(beanFactory, DefaultListableBeanFactory.class);
    }

    public static Set<Class<?>> getResolvableDependencyTypes(ConfigurableListableBeanFactory beanFactory) {
        return BeanFactoryUtils.getResolvableDependencyTypes(BeanFactoryUtils.asDefaultListableBeanFactory(beanFactory));
    }

    public static Set<Class<?>> getResolvableDependencyTypes(DefaultListableBeanFactory beanFactory) {
        Map resolvableDependencies = (Map)FieldUtils.getFieldValue((Object)beanFactory, (String)"resolvableDependencies", Map.class);
        return resolvableDependencies == null ? Collections.emptySet() : resolvableDependencies.keySet();
    }

    public static List<BeanPostProcessor> getBeanPostProcessors(@Nullable BeanFactory beanFactory) {
        List<Object> beanPostProcessors;
        if (beanFactory instanceof AbstractBeanFactory) {
            AbstractBeanFactory abf = (AbstractBeanFactory)beanFactory;
            beanPostProcessors = Collections.unmodifiableList(abf.getBeanPostProcessors());
        } else {
            beanPostProcessors = Collections.emptyList();
        }
        return beanPostProcessors;
    }

    private static <T> T cast(@Nullable Object beanFactory, Class<T> extendedBeanFactoryType) {
        if (beanFactory == null) {
            return null;
        }
        if (beanFactory instanceof ApplicationContext) {
            ApplicationContext context = (ApplicationContext)beanFactory;
            beanFactory = context.getAutowireCapableBeanFactory();
        }
        Assert.isInstanceOf(extendedBeanFactoryType, (Object)beanFactory, (String)("The 'beanFactory' argument is not a instance of " + extendedBeanFactoryType + ", is it running in Spring container?"));
        return extendedBeanFactoryType.cast(beanFactory);
    }
}

