/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory;

import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.ListUtils;
import io.microsphere.collection.MapUtils;
import io.microsphere.collection.SetUtils;
import io.microsphere.lang.function.ThrowableAction;
import io.microsphere.lang.function.ThrowableSupplier;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.MemberUtils;
import io.microsphere.spring.beans.factory.BeanDependencyResolver;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.beans.factory.InjectionPointDependencyResolvers;
import io.microsphere.spring.beans.factory.config.BeanDefinitionUtils;
import io.microsphere.spring.beans.factory.filter.ResolvableDependencyTypeFilter;
import io.microsphere.util.ClassLoaderUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StopWatch;

public class DefaultBeanDependencyResolver
implements BeanDependencyResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBeanDependencyResolver.class);
    private static final ThreadLocal<Set<Member>> resolvedBeanMembersHolder = InheritableThreadLocal.withInitial(SetUtils::newLinkedHashSet);
    private final DefaultListableBeanFactory beanFactory;
    private final ClassLoader classLoader;
    private final ResolvableDependencyTypeFilter resolvableDependencyTypeFilter;
    private final InjectionPointDependencyResolvers resolvers;
    private final List<SmartInstantiationAwareBeanPostProcessor> smartInstantiationAwareBeanPostProcessors;
    private final ExecutorService executorService;

    public DefaultBeanDependencyResolver(BeanFactory bf, ExecutorService executorService) {
        this.beanFactory = BeanFactoryUtils.asDefaultListableBeanFactory(bf);
        this.classLoader = this.beanFactory.getBeanClassLoader();
        this.resolvableDependencyTypeFilter = new ResolvableDependencyTypeFilter(this.beanFactory);
        this.resolvers = new InjectionPointDependencyResolvers((BeanFactory)this.beanFactory);
        this.smartInstantiationAwareBeanPostProcessors = this.getSmartInstantiationAwareBeanPostProcessors((ConfigurableListableBeanFactory)this.beanFactory);
        this.executorService = executorService;
    }

    @Override
    public Map<String, Set<String>> resolve(ConfigurableListableBeanFactory bf) {
        DefaultListableBeanFactory beanFactory = this.beanFactory;
        if (beanFactory != bf) {
            logger.warn("Current BeanFactory[{}] is not a instance of DefaultListableBeanFactory", new Object[]{bf});
            return Collections.emptyMap();
        }
        StopWatch stopWatch = new StopWatch("BeanDependencyResolver");
        Map<String, RootBeanDefinition> eligibleBeanDefinitionsMap = this.getEligibleBeanDefinitionsMap(beanFactory, stopWatch);
        this.preProcessLoadBeanClasses(eligibleBeanDefinitionsMap, stopWatch);
        Map<String, Set<String>> dependentBeanNamesMap = this.resolveDependentBeanNamesMap(eligibleBeanDefinitionsMap, stopWatch);
        this.flattenDependentBeanNamesMap(dependentBeanNamesMap, stopWatch);
        DefaultBeanDependencyResolver.clearResolvedBeanMembers();
        logger.info(stopWatch.toString());
        return dependentBeanNamesMap;
    }

    private Map<String, Set<String>> resolveDependentBeanNamesMap(Map<String, RootBeanDefinition> eligibleBeanDefinitionsMap, StopWatch stopWatch) {
        stopWatch.start("resolveDependentBeanNamesMap");
        int beansCount = eligibleBeanDefinitionsMap.size();
        HashMap dependentBeanNamesMap = MapUtils.newHashMap((int)beansCount);
        ExecutorCompletionService<Map.Entry> completionService = new ExecutorCompletionService<Map.Entry>(this.executorService);
        for (Map.Entry<String, RootBeanDefinition> entry : eligibleBeanDefinitionsMap.entrySet()) {
            completionService.submit(() -> {
                String beanName = (String)entry.getKey();
                RootBeanDefinition beanDefinition = (RootBeanDefinition)entry.getValue();
                Set<String> dependentBeanNames = this.resolve(beanName, beanDefinition, (ConfigurableListableBeanFactory)this.beanFactory);
                return MapUtils.ofEntry((Object)beanName, dependentBeanNames);
            });
        }
        for (int i = 0; i < beansCount; ++i) {
            ThrowableAction.execute(() -> {
                Future future = completionService.take();
                Map.Entry entry = (Map.Entry)future.get();
                String beanName = (String)entry.getKey();
                Set dependentBeanNames = (Set)entry.getValue();
                dependentBeanNamesMap.put(beanName, dependentBeanNames);
            });
        }
        stopWatch.stop();
        return dependentBeanNamesMap;
    }

    private void preProcessLoadBeanClasses(Map<String, RootBeanDefinition> eligibleBeanDefinitionsMap, StopWatch stopWatch) {
        stopWatch.start("preProcessLoadBeanClasses");
        ClassLoader classLoader = this.classLoader;
        for (Map.Entry<String, RootBeanDefinition> entry : eligibleBeanDefinitionsMap.entrySet()) {
            String beanName = entry.getKey();
            RootBeanDefinition beanDefinition = entry.getValue();
            this.preProcessLoadBeanClass(beanName, beanDefinition, eligibleBeanDefinitionsMap, classLoader);
        }
        this.awaitTasksCompleted();
        stopWatch.stop();
    }

    private void awaitTasksCompleted() {
        while (((Boolean)ThrowableSupplier.execute(() -> this.executorService.awaitTermination(10L, TimeUnit.MILLISECONDS))).booleanValue()) {
        }
    }

    private void preProcessLoadBeanClass(String beanName, RootBeanDefinition beanDefinition, Map<String, RootBeanDefinition> beanDefinitionsMap, ClassLoader classLoader) {
        if (beanDefinition.hasBeanClass()) {
            return;
        }
        String beanClassName = beanDefinition.getBeanClassName();
        if (beanClassName == null) {
            String factoryBeanName;
            if (beanDefinition.getResolvedFactoryMethod() == null && (factoryBeanName = beanDefinition.getFactoryBeanName()) != null) {
                RootBeanDefinition factoryBeanDefinition = this.getMergedBeanDefinition(factoryBeanName, beanDefinitionsMap);
                this.preProcessLoadBeanClass(factoryBeanName, factoryBeanDefinition, beanDefinitionsMap, classLoader);
            }
        } else {
            this.executorService.execute(() -> {
                Class beanClass = ClassLoaderUtils.loadClass((String)beanClassName, (ClassLoader)classLoader, (boolean)true);
                beanDefinition.setBeanClass(beanClass);
                if (logger.isTraceEnabled()) {
                    logger.trace("The bean[name : '{}'] class[name : '{}'] was loaded", new Object[]{beanName, beanClassName});
                }
            });
        }
    }

    private RootBeanDefinition getMergedBeanDefinition(String beanName, Map<String, RootBeanDefinition> beanDefinitionsMap) {
        RootBeanDefinition beanDefinition = beanDefinitionsMap.get(beanName);
        if (beanDefinition == null) {
            beanDefinition = (RootBeanDefinition)this.beanFactory.getMergedBeanDefinition(beanName);
        }
        return beanDefinition;
    }

    @Override
    public Set<String> resolve(String beanName, RootBeanDefinition mergedBeanDefinition, ConfigurableListableBeanFactory bf) {
        DefaultListableBeanFactory beanFactory = this.beanFactory;
        if (beanFactory != bf) {
            logger.warn("Current BeanFactory[{}] is not a instance of DefaultListableBeanFactory", new Object[]{bf});
            return Collections.emptySet();
        }
        return this.resolveDependentBeanNames(beanName, mergedBeanDefinition, beanFactory);
    }

    private void flattenDependentBeanNamesMap(Map<String, Set<String>> dependentBeanNamesMap, StopWatch stopWatch) {
        String beanName;
        stopWatch.start("flattenDependentBeanNamesMap");
        for (Map.Entry<String, Set<String>> entry : dependentBeanNamesMap.entrySet()) {
            Set<String> dependentBeanNames = entry.getValue();
            if (dependentBeanNames.isEmpty()) continue;
            beanName = entry.getKey();
            LinkedHashSet<String> flattenDependentBeanNames = new LinkedHashSet<String>(dependentBeanNames.size() * 2);
            this.flatDependentBeanNames(beanName, dependentBeanNamesMap, flattenDependentBeanNames);
            entry.setValue(flattenDependentBeanNames);
        }
        LinkedHashSet<String> nonRootBeanNames = new LinkedHashSet<String>();
        block1: for (Map.Entry<String, Set<String>> entry : dependentBeanNamesMap.entrySet()) {
            beanName = entry.getKey();
            Set<String> dependentBeanNames = entry.getValue();
            for (String dependentBeanName : dependentBeanNames) {
                Set<String> nestedDependentBeanNames = dependentBeanNamesMap.get(dependentBeanName);
                if (!CollectionUtils.isNotEmpty(nestedDependentBeanNames) || dependentBeanNames.containsAll(nestedDependentBeanNames)) continue;
                nonRootBeanNames.add(beanName);
                continue block1;
            }
        }
        for (String nonRootBeanName : nonRootBeanNames) {
            if (dependentBeanNamesMap.remove(nonRootBeanName) == null) continue;
            logger.trace("Non Root Bean name was removed : {}", new Object[]{nonRootBeanName});
        }
        this.logDependentBeanNames(dependentBeanNamesMap);
        stopWatch.stop();
    }

    private void logDependentBeanNames(Map<String, Set<String>> dependentBeanNamesMap) {
        if (logger.isTraceEnabled()) {
            for (Map.Entry<String, Set<String>> entry : dependentBeanNamesMap.entrySet()) {
                logger.trace("The bean : '{}' <- bean dependencies : {}", new Object[]{entry.getKey(), entry.getValue()});
            }
        }
    }

    private void flatDependentBeanNames(String beanName, Map<String, Set<String>> dependentBeanNamesMap, Set<String> flattenDependentBeanNames) {
        Set<String> dependentBeanNames = this.retrieveDependentBeanNames(beanName, dependentBeanNamesMap);
        if (dependentBeanNames.isEmpty()) {
            return;
        }
        dependentBeanNames.remove(beanName);
        for (String dependentBeanName : dependentBeanNames) {
            if (!flattenDependentBeanNames.add(dependentBeanName)) continue;
            this.flatDependentBeanNames(dependentBeanName, dependentBeanNamesMap, flattenDependentBeanNames);
        }
    }

    private Set<String> retrieveDependentBeanNames(String beanName, Map<String, Set<String>> dependentBeanNamesMap) {
        Set<String> dependentBeanNames = dependentBeanNamesMap.get(beanName);
        if (dependentBeanNames == null) {
            dependentBeanNames = Collections.emptySet();
        } else {
            dependentBeanNames.remove(beanName);
        }
        return dependentBeanNames;
    }

    private Set<String> resolveDependentBeanNames(String beanName, RootBeanDefinition beanDefinition, DefaultListableBeanFactory beanFactory) {
        LinkedHashSet<String> dependentBeanNames = new LinkedHashSet<String>();
        this.resolveBeanDefinitionDependentBeanNames(beanDefinition, dependentBeanNames);
        this.resolveConstructionParametersDependentBeanNames(beanName, beanDefinition, beanFactory, dependentBeanNames);
        this.resolveInjectionPointsDependentBeanNames(beanName, beanDefinition, beanFactory, dependentBeanNames);
        dependentBeanNames.remove(beanName);
        this.removeReadyBeanNames(dependentBeanNames, beanFactory);
        return dependentBeanNames;
    }

    private void resolveInjectionPointsDependentBeanNames(String beanName, RootBeanDefinition beanDefinition, DefaultListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        boolean isInterfaceBean;
        ClassLoader classLoader = this.classLoader;
        Class beanClass = this.resolveBeanClass(beanDefinition, classLoader);
        if (beanClass == null) {
            ResolvableType resolvableType = beanDefinition.getResolvableType();
            beanClass = resolvableType.resolve();
        }
        if (isInterfaceBean = beanClass.isInterface()) {
            logger.trace("The resolved type of BeanDefinition : {}", new Object[]{beanClass.getName()});
            return;
        }
        this.resolveFieldDependentBeanNames(beanName, beanClass, beanFactory, dependentBeanNames);
        this.resolveMethodParametersDependentBeanNames(beanName, beanClass, beanFactory, dependentBeanNames);
    }

    private void resolveMethodParametersDependentBeanNames(String beanName, Class beanClass, DefaultListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        Class targetClass = beanClass;
        do {
            ReflectionUtils.doWithLocalMethods((Class)targetClass, method -> {
                if (MemberUtils.isStatic((Member)method)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("The Injection Point[bean : '{}' , class : {}] is not supported on static method : {}", new Object[]{beanName, method.getDeclaringClass().getName(), method});
                    }
                    return;
                }
                int length = method.getParameterCount();
                if (length > 0) {
                    Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
                    if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)method, (Method)bridgedMethod)) {
                        return;
                    }
                    if (method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)beanClass))) {
                        if (DefaultBeanDependencyResolver.isBeanMemberResolved(method)) {
                            logger.trace("The beans'[name : '{}'] method has been resolved : {}", new Object[]{beanName, method});
                        } else {
                            this.resolvers.resolve(method, (ConfigurableListableBeanFactory)beanFactory, dependentBeanNames);
                            DefaultBeanDependencyResolver.addResolvedBeanMember(method);
                        }
                    }
                }
            });
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    private void resolveFieldDependentBeanNames(String beanName, Class beanClass, DefaultListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        Class targetClass = beanClass;
        do {
            ReflectionUtils.doWithLocalFields((Class)targetClass, field -> {
                if (MemberUtils.isStatic((Member)field)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("The Injection Point[bean : '{}' , class : {}] is not supported on static field : {}", new Object[]{beanName, field.getDeclaringClass().getName(), field});
                    }
                    return;
                }
                if (DefaultBeanDependencyResolver.isBeanMemberResolved(field)) {
                    logger.trace("The beans'[name : '{}'] field has been resolved : {}", new Object[]{beanName, field});
                } else {
                    this.resolvers.resolve(field, (ConfigurableListableBeanFactory)beanFactory, dependentBeanNames);
                    DefaultBeanDependencyResolver.addResolvedBeanMember(field);
                }
            });
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    private void removeReadyBeanNames(Set<String> dependentBeanNames, DefaultListableBeanFactory beanFactory) {
        if (dependentBeanNames.isEmpty()) {
            return;
        }
        Iterator<String> iterator = dependentBeanNames.iterator();
        while (iterator.hasNext()) {
            String dependentBeanName = iterator.next();
            if (!this.isBeanReady(dependentBeanName, beanFactory)) continue;
            logger.trace("The dependent bean name['{}'] is removed since it's ready!", new Object[]{dependentBeanName});
            iterator.remove();
        }
    }

    private void resolveBeanDefinitionDependentBeanNames(RootBeanDefinition beanDefinition, Set<String> dependentBeanNames) {
        List<String> dependsOnBeanNames = this.getDependsOnBeanNames(beanDefinition);
        List<String> refBeanNames = this.getRefBeanNames(beanDefinition);
        String factoryBeanName = beanDefinition.getFactoryBeanName();
        boolean hasFactoryBean = factoryBeanName != null;
        int size = dependsOnBeanNames.size() + refBeanNames.size() + (hasFactoryBean ? 1 : 0);
        if (size < 1) {
            return;
        }
        dependentBeanNames.addAll(dependsOnBeanNames);
        dependentBeanNames.addAll(refBeanNames);
        if (hasFactoryBean) {
            dependentBeanNames.add(factoryBeanName);
        }
    }

    private List<String> getDependsOnBeanNames(RootBeanDefinition beanDefinition) {
        Object[] dependsOn = beanDefinition.getDependsOn();
        return ObjectUtils.isEmpty((Object[])dependsOn) ? Collections.emptyList() : Arrays.asList(dependsOn);
    }

    private List<String> getRefBeanNames(RootBeanDefinition beanDefinition) {
        MutablePropertyValues mutablePropertyValues = beanDefinition.getPropertyValues();
        PropertyValue[] propertyValues = mutablePropertyValues.getPropertyValues();
        int propertyValuesLength = propertyValues.length;
        if (propertyValuesLength < 1) {
            return Collections.emptyList();
        }
        LinkedList dependentBeanNames = ListUtils.newLinkedList();
        for (int i = 0; i < propertyValuesLength; ++i) {
            PropertyValue propertyValue = propertyValues[i];
            Object value = propertyValue.getValue();
            if (!(value instanceof BeanReference)) continue;
            BeanReference beanReference = (BeanReference)value;
            String beanName = beanReference.getBeanName();
            dependentBeanNames.add(beanName);
        }
        return dependentBeanNames;
    }

    private void resolveConstructionParametersDependentBeanNames(String beanName, RootBeanDefinition beanDefinition, DefaultListableBeanFactory beanFactory, Set<String> dependentBeanNames) {
        Method factoryMethod = beanDefinition.getResolvedFactoryMethod();
        if (factoryMethod == null) {
            Class<?> beanClass = this.resolveBeanClass(beanDefinition, this.classLoader);
            Constructor[] constructors = this.resolveConstructors(beanName, beanClass);
            int constructorsLength = constructors.length;
            if (constructorsLength != 1) {
                logger.warn("Why the Bean[name : '{}' , class : {} ] has {} constructors?", new Object[]{beanName, beanClass, constructorsLength});
            } else {
                Constructor constructor = constructors[0];
                if (DefaultBeanDependencyResolver.isBeanMemberResolved(constructor)) {
                    logger.trace("The beans'[name : '{}'] constructor has been resolved : {}", new Object[]{beanName, constructor});
                } else {
                    this.resolvers.resolve(constructor, (ConfigurableListableBeanFactory)beanFactory, dependentBeanNames);
                    DefaultBeanDependencyResolver.addResolvedBeanMember(constructor);
                }
            }
        } else if (DefaultBeanDependencyResolver.isBeanMemberResolved(factoryMethod)) {
            logger.trace("The beans'[name : '{}'] factory-method has been resolved : {}", new Object[]{beanName, factoryMethod});
        } else {
            this.resolvers.resolve(factoryMethod, (ConfigurableListableBeanFactory)beanFactory, dependentBeanNames);
            DefaultBeanDependencyResolver.addResolvedBeanMember(factoryMethod);
        }
    }

    private Constructor[] resolveConstructors(String beanName, Class<?> beanClass) {
        Object[] constructors = null;
        if (!beanClass.isInterface()) {
            SmartInstantiationAwareBeanPostProcessor processor;
            List<SmartInstantiationAwareBeanPostProcessor> processors = this.smartInstantiationAwareBeanPostProcessors;
            Iterator<SmartInstantiationAwareBeanPostProcessor> iterator = processors.iterator();
            while (iterator.hasNext() && (constructors = (processor = iterator.next()).determineCandidateConstructors(beanClass, beanName)) == null) {
            }
        }
        constructors = ObjectUtils.isEmpty(constructors) ? beanClass.getConstructors() : constructors;
        constructors = ObjectUtils.isEmpty((Object[])constructors) ? beanClass.getDeclaredConstructors() : constructors;
        return constructors;
    }

    private List<SmartInstantiationAwareBeanPostProcessor> getSmartInstantiationAwareBeanPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory dbf = (DefaultListableBeanFactory)beanFactory;
            LinkedList<SmartInstantiationAwareBeanPostProcessor> processors = new LinkedList<SmartInstantiationAwareBeanPostProcessor>();
            List beanPostProcessors = dbf.getBeanPostProcessors();
            for (BeanPostProcessor beanPostProcessor : beanPostProcessors) {
                if (!(beanPostProcessor instanceof SmartInstantiationAwareBeanPostProcessor)) continue;
                SmartInstantiationAwareBeanPostProcessor siaBeanProcessor = (SmartInstantiationAwareBeanPostProcessor)beanPostProcessor;
                processors.add(siaBeanProcessor);
            }
            return processors;
        }
        return Collections.emptyList();
    }

    private Class<?> resolveBeanClass(RootBeanDefinition beanDefinition, @Nullable ClassLoader classLoader) {
        return BeanDefinitionUtils.resolveBeanType(beanDefinition, classLoader);
    }

    private Map<String, RootBeanDefinition> getEligibleBeanDefinitionsMap(DefaultListableBeanFactory beanFactory, StopWatch stopWatch) {
        stopWatch.start("getEligibleBeanDefinitionsMap");
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        int beansCount = beanNames.length;
        HashMap eligibleBeanDefinitionsMap = MapUtils.newHashMap((int)beansCount);
        for (int i = 0; i < beansCount; ++i) {
            String beanName = beanNames[i];
            if (this.isBeanReady(beanName, beanFactory)) continue;
            if (beanFactory.isCurrentlyInCreation(beanName)) {
                logger.trace("The Bean[name : '{}'] is creating currently", new Object[]{beanName});
                continue;
            }
            BeanDefinition beanDefinition = beanFactory.getMergedBeanDefinition(beanName);
            RootBeanDefinition eligibleBeanDefinition = this.getEligibleBeanDefinition(beanDefinition);
            if (eligibleBeanDefinition == null) continue;
            BeanDefinitionHolder beanDefinitionHolder = eligibleBeanDefinition.getDecoratedDefinition();
            if (beanDefinitionHolder == null) {
                String[] aliases = beanFactory.getAliases(beanName);
                beanDefinitionHolder = new BeanDefinitionHolder(beanDefinition, beanName, aliases);
                eligibleBeanDefinition.setDecoratedDefinition(beanDefinitionHolder);
            }
            eligibleBeanDefinitionsMap.put(beanName, eligibleBeanDefinition);
        }
        stopWatch.stop();
        return eligibleBeanDefinitionsMap;
    }

    private RootBeanDefinition getEligibleBeanDefinition(BeanDefinition beanDefinition) {
        if (beanDefinition != null && !beanDefinition.isAbstract() && beanDefinition.isSingleton() && !beanDefinition.isLazyInit() && beanDefinition instanceof RootBeanDefinition) {
            RootBeanDefinition rootBeanDefinition = (RootBeanDefinition)beanDefinition;
            Supplier instanceSupplier = rootBeanDefinition.getInstanceSupplier();
            return instanceSupplier == null ? rootBeanDefinition : null;
        }
        return null;
    }

    private boolean isBeanReady(String beanName, DefaultListableBeanFactory beanFactory) {
        boolean ready = beanFactory.containsSingleton(beanName);
        if (ready && logger.isTraceEnabled()) {
            logger.trace("The Bean[name : '{}'] is ready in the BeanFactory[id : '{}']", new Object[]{beanName, beanFactory.getSerializationId()});
        }
        return ready;
    }

    private static Set<Member> getResolvedBeanMembers() {
        return resolvedBeanMembersHolder.get();
    }

    private static void addResolvedBeanMember(Member resolvedBeanMember) {
        Set<Member> resolvedBeanMembers = DefaultBeanDependencyResolver.getResolvedBeanMembers();
        resolvedBeanMembers.add(resolvedBeanMember);
    }

    private static boolean isBeanMemberResolved(Member member) {
        Set<Member> resolvedBeanMembers = DefaultBeanDependencyResolver.getResolvedBeanMembers();
        return resolvedBeanMembers.contains(member);
    }

    private static void clearResolvedBeanMembers() {
        resolvedBeanMembersHolder.remove();
    }
}

