/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory;

import io.microsphere.spring.beans.BeanUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DelegatingFactoryBean
implements FactoryBean<Object>,
InitializingBean,
DisposableBean,
ApplicationContextAware,
BeanNameAware {
    private final Object delegate;
    private final Class<?> objectType;
    private final boolean singleton;

    public DelegatingFactoryBean(Object delegate) {
        this(delegate, true);
    }

    public DelegatingFactoryBean(Object delegate, boolean singleton) {
        this.delegate = delegate;
        this.objectType = AopUtils.getTargetClass((Object)delegate);
        this.singleton = singleton;
    }

    public Object getObject() throws Exception {
        return this.delegate;
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.invokeInitializingBean(this.delegate);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        BeanUtils.invokeAwareInterfaces(this.delegate, (BeanFactory)context);
    }

    public void setBeanName(String name) {
        BeanUtils.invokeBeanNameAware(this.delegate, name);
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void destroy() throws Exception {
        Object object = this.delegate;
        if (object instanceof DisposableBean) {
            DisposableBean disposableBean = (DisposableBean)object;
            disposableBean.destroy();
        }
    }
}

