/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory;

import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.ListUtils;
import io.microsphere.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.springframework.util.Assert;

public class Dependency {
    final String beanName;
    List<Dependency> upstream;
    List<Dependency> downstream;
    @Nullable
    @Deprecated
    Dependency parent = null;
    @Deprecated
    final List<Dependency> children = ListUtils.newLinkedList();
    boolean duplicated = false;

    protected Dependency(String beanName) {
        this(beanName, null, Collections.emptyList());
    }

    protected Dependency(String beanName, Dependency parent, String ... dependentBeanNames) {
        this(beanName, parent, Dependency.createList(dependentBeanNames));
    }

    protected Dependency(String beanName, Dependency parent, Collection<Dependency> children) {
        Assert.hasText((String)beanName, (String)"The bean name of dependency must not be blank");
        this.beanName = beanName;
        this.parent = parent;
        this.doAddChildren(children);
    }

    public Dependency setParent(Dependency parent) {
        this.parent = parent;
        return this;
    }

    public Dependency root() {
        Dependency root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root;
    }

    public Dependency parent() {
        return this.parent;
    }

    public Dependency addChild(String childBeanName) {
        return this.doAddChild(Dependency.create(childBeanName));
    }

    public Dependency addChildren(String ... childBeanNames) {
        return this.doAddChildren(Dependency.createList(childBeanNames));
    }

    public Dependency addChildren(Iterable<String> childBeanNames) {
        return this.doAddChildren(Dependency.createList(childBeanNames));
    }

    public Dependency child(String childBeanName) {
        return this.child(childBeanName, false);
    }

    public Dependency child(String childBeanName, boolean addedIfAbsent) {
        Dependency child = this.findChild(childBeanName);
        return addedIfAbsent && child == null ? Dependency.create(childBeanName) : child;
    }

    protected Dependency findChild(String childBeanName) {
        List<Dependency> children = this.children;
        for (Dependency child : children) {
            if (!child.beanName.equals(childBeanName)) continue;
            return child;
        }
        return null;
    }

    protected Dependency duplicate() {
        this.duplicated = true;
        return this;
    }

    protected Dependency doAddChild(Dependency child) {
        child.setParent(this);
        this.children.add(child);
        return this;
    }

    protected Dependency doAddChildren(Dependency ... children) {
        this.doAddChildren(Arrays.asList(children));
        return this;
    }

    protected Dependency doAddChildren(Iterable<Dependency> children) {
        for (Dependency child : children) {
            this.doAddChild(child);
        }
        return this;
    }

    public static Dependency create(String beanName) {
        return new Dependency(beanName);
    }

    public static Dependency create(String beanName, Dependency parent, String ... dependentBeanNames) {
        return new Dependency(beanName, parent, dependentBeanNames);
    }

    private static List<Dependency> createList(Iterable<String> beanNames) {
        int length = CollectionUtils.size(beanNames);
        if (length < 1) {
            return Collections.emptyList();
        }
        ArrayList dependencies = ListUtils.newArrayList((int)length);
        Iterator<String> iterator = beanNames.iterator();
        while (iterator.hasNext()) {
            dependencies.add(Dependency.create(iterator.next()));
        }
        return dependencies;
    }

    private static List<Dependency> createList(String[] beanNames) {
        int length = ArrayUtils.length((Object[])beanNames);
        if (length < 1) {
            return Collections.emptyList();
        }
        ArrayList dependencies = ListUtils.newArrayList((int)length);
        for (int i = 0; i < length; ++i) {
            dependencies.add(Dependency.create(beanNames[i]));
        }
        return dependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        return this.beanName.equals(that.beanName);
    }

    public int hashCode() {
        return Objects.hash(this.beanName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.beanName);
        if (!this.children.isEmpty()) {
            sb.append(this.children);
        }
        return sb.toString();
    }
}

