/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory;

import io.microsphere.collection.CollectionUtils;
import io.microsphere.spring.beans.factory.Dependency;
import java.util.Iterator;
import java.util.List;

public class DependencyTreeWalker {
    public Dependency walk(Dependency dependency) {
        List<Dependency> children = dependency.children;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Dependency child = children.get(i);
            List<Dependency> siblings = children.subList(i + 1, size);
            this.walk(child, siblings);
        }
        this.removeIfDuplicated(dependency);
        return dependency;
    }

    private void removeIfDuplicated(Dependency dependency) {
        List<Dependency> children = dependency.children;
        Iterator<Dependency> iterator = children.iterator();
        while (iterator.hasNext()) {
            Dependency child = iterator.next();
            this.removeIfDuplicated(child);
            if (!child.duplicated) continue;
            iterator.remove();
        }
    }

    private void walk(Dependency child, List<Dependency> siblings) {
        if (CollectionUtils.isEmpty(siblings)) {
            return;
        }
        if (siblings.contains(child)) {
            child.duplicate();
        }
        for (Dependency sibling : siblings) {
            if (child.equals(sibling)) {
                child.duplicate();
                this.mergeChildren(child, sibling);
            }
            this.walk(child, sibling.children);
        }
    }

    private void mergeChildren(Dependency child, Dependency sibling) {
        List<Dependency> sources = child.children;
        List<Dependency> targets = sibling.children;
        if (!sources.equals(targets)) {
            for (Dependency source : sources) {
                if (targets.contains(source)) continue;
                targets.add(source);
            }
        }
    }
}

