/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory.annotation;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.context.annotation.AnnotatedBeanDefinitionRegistryUtils;
import io.microsphere.spring.context.annotation.ExposingClassPathBeanDefinitionScanner;
import io.microsphere.spring.core.annotation.AnnotationUtils;
import io.microsphere.spring.core.env.EnvironmentUtils;
import io.microsphere.util.ArrayUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AnnotationBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryAware,
EnvironmentAware,
ResourceLoaderAware,
BeanClassLoaderAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<Class<? extends Annotation>> supportedAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>();
    private final Set<String> packagesToScan;
    private ConfigurableListableBeanFactory beanFactory;
    private ConfigurableEnvironment environment;
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;

    public AnnotationBeanDefinitionRegistryPostProcessor(Class<? extends Annotation> primaryAnnotationType, Class<?> ... basePackageClasses) {
        this(primaryAnnotationType, AnnotationBeanDefinitionRegistryPostProcessor.resolveBasePackages(basePackageClasses));
    }

    public AnnotationBeanDefinitionRegistryPostProcessor(Class<? extends Annotation> primaryAnnotationType, String ... packagesToScan) {
        this(primaryAnnotationType, Arrays.asList(packagesToScan));
    }

    public AnnotationBeanDefinitionRegistryPostProcessor(Class<? extends Annotation> primaryAnnotationType, Iterable<String> packagesToScan) {
        this.addSupportedAnnotationType(primaryAnnotationType);
        this.packagesToScan = new LinkedHashSet<String>();
        Iterator<String> iterator = packagesToScan.iterator();
        while (iterator.hasNext()) {
            this.packagesToScan.add(iterator.next());
        }
    }

    public void addSupportedAnnotationType(Class<? extends Annotation> ... annotationTypes) {
        Assert.notEmpty((Object[])annotationTypes, (String)"The argument of annotation types can't be empty");
        Assert.noNullElements((Object[])annotationTypes, (String)"Any element of annotation types can't be null");
        this.supportedAnnotationTypes.addAll(Arrays.asList(annotationTypes));
    }

    private static String[] resolveBasePackages(Class<?> ... basePackageClasses) {
        int size = basePackageClasses.length;
        String[] basePackages = new String[size];
        for (int i = 0; i < size; ++i) {
            basePackages[i] = basePackageClasses[i].getPackage().getName();
        }
        return basePackages;
    }

    protected static Annotation getAnnotation(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType) {
        Annotation annotation = AnnotationUtils.tryGetMergedAnnotation(annotatedElement, annotationType);
        if (annotation == null) {
            annotation = annotatedElement.getAnnotation(annotationType);
        }
        return annotation;
    }

    public final void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        Object[] basePackages = this.resolveBasePackages(this.getPackagesToScan());
        if (ArrayUtils.isNotEmpty((Object[])basePackages)) {
            this.registerBeanDefinitions(registry, (String[])basePackages);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("packagesToScan is empty , The BeanDefinition's registry will be ignored!");
        }
    }

    private void registerBeanDefinitions(BeanDefinitionRegistry registry, String[] basePackages) {
        ExposingClassPathBeanDefinitionScanner scanner = new ExposingClassPathBeanDefinitionScanner(registry, false, (Environment)this.getEnvironment(), this.getResourceLoader());
        BeanNameGenerator beanNameGenerator = AnnotatedBeanDefinitionRegistryUtils.resolveAnnotatedBeanNameGenerator(registry);
        scanner.setBeanNameGenerator(beanNameGenerator);
        for (Class<? extends Annotation> supportedAnnotationType : this.getSupportedAnnotationTypes()) {
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(supportedAnnotationType));
        }
        Map<String, AnnotatedBeanDefinition> primaryBeanDefinitions = this.registerPrimaryBeanDefinitions(scanner, basePackages);
        this.registerSecondaryBeanDefinitions(scanner, primaryBeanDefinitions, basePackages);
    }

    protected Map<String, AnnotatedBeanDefinition> registerPrimaryBeanDefinitions(ExposingClassPathBeanDefinitionScanner scanner, String[] basePackages) {
        Set<BeanDefinitionHolder> primaryBeanDefinitionHolders = scanner.doScan(basePackages);
        this.logPrimaryBeanDefinitions(primaryBeanDefinitionHolders, basePackages);
        LinkedHashMap<String, AnnotatedBeanDefinition> primaryBeanDefinitions = new LinkedHashMap<String, AnnotatedBeanDefinition>();
        for (BeanDefinitionHolder beanDefinitionHolder : primaryBeanDefinitionHolders) {
            this.putPrimaryBeanDefinitions(primaryBeanDefinitions, beanDefinitionHolder);
        }
        return primaryBeanDefinitions;
    }

    private void putPrimaryBeanDefinitions(Map<String, AnnotatedBeanDefinition> primaryBeanDefinitions, BeanDefinitionHolder beanDefinitionHolder) {
        BeanDefinition beanDefinition = beanDefinitionHolder.getBeanDefinition();
        if (beanDefinition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition;
            this.putPrimaryBeanDefinition(primaryBeanDefinitions, annotatedBeanDefinition, beanDefinitionHolder.getBeanName());
            this.putPrimaryBeanDefinition(primaryBeanDefinitions, annotatedBeanDefinition, beanDefinitionHolder.getAliases());
        } else if (this.logger.isErrorEnabled()) {
            this.logger.error("What's the problem? Please investigate " + beanDefinitionHolder);
        }
    }

    private void putPrimaryBeanDefinition(Map<String, AnnotatedBeanDefinition> primaryBeanDefinitions, AnnotatedBeanDefinition annotatedBeanDefinition, String ... keys) {
        if (ArrayUtils.isNotEmpty((Object[])keys)) {
            for (String key : keys) {
                primaryBeanDefinitions.put(key, annotatedBeanDefinition);
            }
        }
    }

    protected abstract void registerSecondaryBeanDefinitions(ExposingClassPathBeanDefinitionScanner var1, Map<String, AnnotatedBeanDefinition> var2, String[] var3);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private void logPrimaryBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitionHolders, String[] basePackages) {
        if (CollectionUtils.isEmpty(beanDefinitionHolders)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("No Spring Bean annotation @" + this.getSupportedAnnotationTypeNames() + " was found under base packages" + Arrays.asList(basePackages));
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info(beanDefinitionHolders.size() + " annotations " + this.getSupportedAnnotationTypeNames() + " components { " + beanDefinitionHolders + " } were scanned under packages" + Arrays.asList(basePackages));
        }
    }

    protected String[] resolveBasePackages(Set<String> packagesToScan) {
        LinkedHashSet<String> resolvedPackagesToScan = new LinkedHashSet<String>(packagesToScan.size());
        for (String packageToScan : packagesToScan) {
            if (!StringUtils.hasText((String)packageToScan)) continue;
            String resolvedPackageToScan = this.getEnvironment().resolvePlaceholders(packageToScan.trim());
            resolvedPackagesToScan.add(resolvedPackageToScan);
        }
        return packagesToScan.toArray(new String[packagesToScan.size()]);
    }

    protected final Class<?> resolveBeanClass(BeanDefinitionHolder beanDefinitionHolder) {
        BeanDefinition beanDefinition = beanDefinitionHolder.getBeanDefinition();
        return this.resolveBeanClass(beanDefinition);
    }

    protected final Class<?> resolveBeanClass(BeanDefinition beanDefinition) {
        String beanClassName = beanDefinition.getBeanClassName();
        return ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)this.getClassLoader());
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Set<Class<? extends Annotation>> getSupportedAnnotationTypes() {
        return Collections.unmodifiableSet(this.supportedAnnotationTypes);
    }

    protected Set<String> getSupportedAnnotationTypeNames() {
        LinkedHashSet<String> supportedAnnotationTypeNames = new LinkedHashSet<String>();
        for (Class<? extends Annotation> supportedAnnotationType : this.supportedAnnotationTypes) {
            supportedAnnotationTypeNames.add(supportedAnnotationType.getName());
        }
        return Collections.unmodifiableSet(supportedAnnotationTypeNames);
    }

    public Set<String> getPackagesToScan() {
        return this.packagesToScan;
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = BeanFactoryUtils.asConfigurableListableBeanFactory(beanFactory);
    }

    public ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = EnvironmentUtils.asConfigurableEnvironment(environment);
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

