/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory.annotation;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.TypeUtils;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Deprecated
public abstract class AnnotationInjectedBeanPostProcessor<A extends Annotation>
extends InstantiationAwareBeanPostProcessorAdapter
implements MergedBeanDefinitionPostProcessor,
PriorityOrdered,
BeanFactoryAware,
BeanClassLoaderAware,
EnvironmentAware,
DisposableBean {
    private static final int CACHE_SIZE = Integer.getInteger("microsphere.spring.injection.metadata.cache.size", 32);
    private static final PropertyDescriptor[] EMPTY_PROPERTY_DESCRIPTOR_ARRAY = new PropertyDescriptor[0];
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<A> annotationType;
    private final ConcurrentMap<String, AnnotatedInjectionMetadata> injectionMetadataCache = new ConcurrentHashMap<String, AnnotatedInjectionMetadata>(CACHE_SIZE);
    private final ConcurrentMap<String, Object> injectedObjectsCache = new ConcurrentHashMap<String, Object>(CACHE_SIZE);
    private ConfigurableListableBeanFactory beanFactory;
    private Environment environment;
    private ClassLoader classLoader;
    private int order = Integer.MAX_VALUE;

    public AnnotationInjectedBeanPostProcessor() {
        this.annotationType = TypeUtils.resolveActualTypeArgumentClass(this.getClass(), AnnotationInjectedBeanPostProcessor.class, (int)0);
    }

    private static <T> Collection<T> combine(Collection<? extends T> ... elements) {
        ArrayList<? extends T> allElements = new ArrayList<T>();
        for (Collection<? extends T> e : elements) {
            allElements.addAll(e);
        }
        return allElements;
    }

    public final Class<A> getAnnotationType() {
        return this.annotationType;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = BeanFactoryUtils.asConfigurableListableBeanFactory(beanFactory);
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeanCreationException {
        InjectionMetadata metadata = this.findInjectionMetadata(beanName, bean.getClass(), pvs);
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (BeanCreationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of @" + this.getAnnotationType().getName() + " dependencies is failed", ex);
        }
        return pvs;
    }

    @Override
    public PropertyValues postProcessProperties(PropertyValues pvs, Object bean, String beanName) throws BeansException {
        return this.postProcessPropertyValues(pvs, EMPTY_PROPERTY_DESCRIPTOR_ARRAY, bean, beanName);
    }

    private List<AnnotatedFieldElement> findFieldAnnotationMetadata(Class<?> beanClass) {
        LinkedList<AnnotatedFieldElement> elements = new LinkedList<AnnotatedFieldElement>();
        ReflectionUtils.doWithFields(beanClass, field -> {
            Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)field, this.getAnnotationType());
            if (annotation != null) {
                if (Modifier.isStatic(field.getModifiers())) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("@" + this.getAnnotationType().getName() + " is not supported on static fields: " + field);
                    }
                    return;
                }
                elements.add(new AnnotatedFieldElement(this, field, annotation));
            }
        });
        return elements;
    }

    private List<AnnotatedMethodElement> findAnnotatedMethodMetadata(Class<?> beanClass) {
        LinkedList<AnnotatedMethodElement> elements = new LinkedList<AnnotatedMethodElement>();
        ReflectionUtils.doWithMethods(beanClass, method -> {
            Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
            if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)method, (Method)bridgedMethod)) {
                return;
            }
            Annotation annotation = AnnotationUtils.findAnnotation((Method)bridgedMethod, this.getAnnotationType());
            if (annotation != null && method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)beanClass))) {
                if (Modifier.isStatic(method.getModifiers())) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("@" + this.getAnnotationType().getSimpleName() + " annotation is not supported on static methods: " + method);
                    }
                    return;
                }
                if (method.getParameterTypes().length == 0 && this.logger.isWarnEnabled()) {
                    this.logger.warn("@" + this.getAnnotationType().getSimpleName() + " annotation should only be used on methods with parameters: " + method);
                }
                PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, (Class)beanClass);
                elements.add(new AnnotatedMethodElement(this, method, pd, annotation));
            }
        });
        return elements;
    }

    private AnnotatedInjectionMetadata buildAnnotatedMetadata(Class<?> beanClass) {
        List<AnnotatedFieldElement> fieldElements = this.findFieldAnnotationMetadata(beanClass);
        List<AnnotatedMethodElement> methodElements = this.findAnnotatedMethodMetadata(beanClass);
        return new AnnotatedInjectionMetadata(beanClass, fieldElements, methodElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findInjectionMetadata(String beanName, Class<?> clazz, PropertyValues pvs) {
        String cacheKey = StringUtils.hasLength((String)beanName) ? beanName : clazz.getName();
        AnnotatedInjectionMetadata metadata = (AnnotatedInjectionMetadata)((Object)this.injectionMetadataCache.get(cacheKey));
        if (InjectionMetadata.needsRefresh((InjectionMetadata)metadata, clazz)) {
            ConcurrentMap<String, AnnotatedInjectionMetadata> concurrentMap = this.injectionMetadataCache;
            synchronized (concurrentMap) {
                metadata = (AnnotatedInjectionMetadata)((Object)this.injectionMetadataCache.get(cacheKey));
                if (InjectionMetadata.needsRefresh((InjectionMetadata)metadata, clazz)) {
                    if (metadata != null) {
                        metadata.clear(pvs);
                    }
                    try {
                        metadata = this.buildAnnotatedMetadata(clazz);
                        this.injectionMetadataCache.put(cacheKey, metadata);
                    }
                    catch (NoClassDefFoundError err) {
                        throw new IllegalStateException("Failed to introspect object class [" + clazz.getName() + "] for annotation metadata: could not find class that it depends on", err);
                    }
                }
            }
        }
        return metadata;
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        if (beanType != null) {
            InjectionMetadata metadata = this.findInjectionMetadata(beanName, beanType, null);
            metadata.checkConfigMembers(beanDefinition);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void destroy() throws Exception {
        for (Object object : this.injectedObjectsCache.values()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(object + " was destroying!");
            }
            if (!(object instanceof DisposableBean)) continue;
            DisposableBean disposableBean = (DisposableBean)object;
            disposableBean.destroy();
        }
        this.injectionMetadataCache.clear();
        this.injectedObjectsCache.clear();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.getClass() + " was destroying!");
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected Collection<Object> getInjectedObjects() {
        return this.injectedObjectsCache.values();
    }

    protected Object getInjectedObject(A annotation, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) throws Exception {
        String cacheKey = this.buildInjectedObjectCacheKey(annotation, bean, beanName, injectedType, injectedElement);
        Object injectedObject = this.injectedObjectsCache.get(cacheKey);
        if (injectedObject == null) {
            injectedObject = this.doGetInjectedBean(annotation, bean, beanName, injectedType, injectedElement);
            this.injectedObjectsCache.putIfAbsent(cacheKey, injectedObject);
        }
        return injectedObject;
    }

    protected abstract Object doGetInjectedBean(A var1, Object var2, String var3, Class<?> var4, InjectionMetadata.InjectedElement var5) throws Exception;

    protected abstract String buildInjectedObjectCacheKey(A var1, Object var2, String var3, Class<?> var4, InjectionMetadata.InjectedElement var5);

    protected Map<InjectionMetadata.InjectedElement, Object> getInjectedFieldObjectsMap() {
        LinkedHashMap<AnnotatedFieldElement, Object> injectedElementBeanMap = new LinkedHashMap<AnnotatedFieldElement, Object>();
        for (AnnotatedInjectionMetadata metadata : this.injectionMetadataCache.values()) {
            Collection<AnnotatedFieldElement> fieldElements = metadata.getFieldElements();
            for (AnnotatedFieldElement fieldElement : fieldElements) {
                injectedElementBeanMap.put(fieldElement, fieldElement.bean);
            }
        }
        return Collections.unmodifiableMap(injectedElementBeanMap);
    }

    protected Map<InjectionMetadata.InjectedElement, Object> getInjectedMethodObjectsMap() {
        LinkedHashMap<AnnotatedMethodElement, Object> injectedElementBeanMap = new LinkedHashMap<AnnotatedMethodElement, Object>();
        for (AnnotatedInjectionMetadata metadata : this.injectionMetadataCache.values()) {
            Collection<AnnotatedMethodElement> methodElements = metadata.getMethodElements();
            for (AnnotatedMethodElement methodElement : methodElements) {
                injectedElementBeanMap.put(methodElement, methodElement.object);
            }
        }
        return Collections.unmodifiableMap(injectedElementBeanMap);
    }

    private class AnnotatedInjectionMetadata
    extends InjectionMetadata {
        private final Collection<AnnotatedFieldElement> fieldElements;
        private final Collection<AnnotatedMethodElement> methodElements;

        public AnnotatedInjectionMetadata(Class<?> targetClass, Collection<AnnotatedFieldElement> fieldElements, Collection<AnnotatedMethodElement> methodElements) {
            super(targetClass, AnnotationInjectedBeanPostProcessor.combine(fieldElements, methodElements));
            this.fieldElements = fieldElements;
            this.methodElements = methodElements;
        }

        public Collection<AnnotatedFieldElement> getFieldElements() {
            return this.fieldElements;
        }

        public Collection<AnnotatedMethodElement> getMethodElements() {
            return this.methodElements;
        }
    }

    public static class AnnotatedFieldElement
    extends InjectionMetadata.InjectedElement {
        private final Field field;
        private final A annotation;
        private volatile Object bean;
        final /* synthetic */ AnnotationInjectedBeanPostProcessor this$0;

        protected AnnotatedFieldElement(Field field, A annotation) {
            this.this$0 = this$0;
            super((Member)field, null);
            this.field = field;
            this.annotation = annotation;
        }

        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            Class<?> injectedType = this.field.getType();
            Object injectedObject = this.this$0.getInjectedObject(this.annotation, bean, beanName, injectedType, this);
            ReflectionUtils.makeAccessible((Field)this.field);
            this.field.set(bean, injectedObject);
        }
    }

    private static class AnnotatedMethodElement
    extends InjectionMetadata.InjectedElement {
        private final Method method;
        private final A annotation;
        private volatile Object object;
        final /* synthetic */ AnnotationInjectedBeanPostProcessor this$0;

        protected AnnotatedMethodElement(Method method, PropertyDescriptor pd, A annotation) {
            this.this$0 = var1_1;
            super((Member)method, pd);
            this.method = method;
            this.annotation = annotation;
        }

        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            Class<?> injectedType = this.pd.getPropertyType();
            Object injectedObject = this.this$0.getInjectedObject(this.annotation, bean, beanName, injectedType, this);
            ReflectionUtils.makeAccessible((Method)this.method);
            this.method.invoke(bean, injectedObject);
        }
    }
}

